/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.util;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.RoutineOverrideImportPath;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsPackage;
import tools.vitruv.dsls.reactions.runtime.structure.ReactionsImportPath;

@Utility
public final class ReactionsLanguageUtil {
    public static String getFormattedMetamodelPair(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> it.getName();
        List sourceMetamodelsNames = ListExtensions.map(reactionsSegment.getFromMetamodels(), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getName();
        List targetMetamodelsNames = ListExtensions.map(reactionsSegment.getToMetamodels(), (Functions.Function1)_function_1);
        return "(" + String.valueOf(sourceMetamodelsNames) + ", " + String.valueOf(targetMetamodelsNames) + ")";
    }

    public static String getFormattedName(ReactionsSegment reactionsSegment) {
        return ReactionsLanguageUtil.getFormattedReactionsSegmentName(reactionsSegment.getName());
    }

    public static String getFormattedReactionsSegmentName(String reactionsSegmentName) {
        return StringExtensions.toFirstLower((String)reactionsSegmentName);
    }

    public static String getFormattedName(Reaction reaction) {
        return StringExtensions.toFirstUpper((String)reaction.getName());
    }

    public static String getQualifiedName(Reaction reaction) {
        String reactionsSegmentName = null;
        boolean _isOverride = ReactionsLanguageUtil.isOverride(reaction);
        if (_isOverride) {
            ReactionsSegment _overriddenReactionsSegment = reaction.getOverriddenReactionsSegment();
            String _name = null;
            if (_overriddenReactionsSegment != null) {
                _name = _overriddenReactionsSegment.getName();
            }
            reactionsSegmentName = _name;
        } else {
            reactionsSegmentName = reaction.getReactionsSegment().getName();
        }
        String _formattedName = ReactionsLanguageUtil.getFormattedName(reaction);
        return reactionsSegmentName + "::" + _formattedName;
    }

    public static String getDisplayName(Reaction reaction) {
        boolean _isOverride = ReactionsLanguageUtil.isOverride(reaction);
        if (_isOverride) {
            return ReactionsLanguageUtil.getQualifiedName(reaction);
        }
        return ReactionsLanguageUtil.getFormattedName(reaction);
    }

    public static String getFormattedName(Routine routine) {
        return StringExtensions.toFirstLower((String)routine.getName());
    }

    public static String getQualifiedName(Routine routine) {
        String reactionsSegmentName = null;
        boolean _isOverride = ReactionsLanguageUtil.isOverride(routine);
        if (_isOverride) {
            ReactionsSegment _reactionsSegment = routine.getOverrideImportPath().getReactionsSegment();
            String _name = null;
            if (_reactionsSegment != null) {
                _name = _reactionsSegment.getName();
            }
            reactionsSegmentName = _name;
        } else {
            reactionsSegmentName = routine.getReactionsSegment().getName();
        }
        String _formattedName = ReactionsLanguageUtil.getFormattedName(routine);
        return reactionsSegmentName + "::" + _formattedName;
    }

    public static String getFullyQualifiedName(Routine routine) {
        return ReactionsLanguageUtil.getFullyQualifiedName(routine, null);
    }

    public static String getFullyQualifiedName(Routine routine, ReactionsImportPath importPath) {
        boolean _isOverride;
        String reactionsSegmentName = routine.getReactionsSegment().getName();
        boolean importPathSpecified = importPath != null && !importPath.isEmpty();
        Object fullyQualifiedName = "";
        if (importPathSpecified) {
            boolean _not;
            String _fullyQualifiedName = fullyQualifiedName;
            String _pathString = importPath.getPathString();
            fullyQualifiedName = _fullyQualifiedName + _pathString;
            boolean _equals = importPath.getLastSegment().equals(reactionsSegmentName);
            boolean bl = _not = !_equals;
            if (_not) {
                Object _fullyQualifiedName_1 = fullyQualifiedName;
                fullyQualifiedName = (String)_fullyQualifiedName_1 + "." + reactionsSegmentName;
            }
        }
        if (_isOverride = ReactionsLanguageUtil.isOverride(routine)) {
            if (importPathSpecified) {
                String _fullyQualifiedName_2 = fullyQualifiedName;
                fullyQualifiedName = _fullyQualifiedName_2 + ".";
            }
            String _fullyQualifiedName_3 = fullyQualifiedName;
            String _pathString_1 = ReactionsLanguageUtil.toReactionsImportPath(routine.getOverrideImportPath()).getPathString();
            fullyQualifiedName = _fullyQualifiedName_3 + _pathString_1;
        } else if (!importPathSpecified) {
            String _fullyQualifiedName_4 = fullyQualifiedName;
            fullyQualifiedName = _fullyQualifiedName_4 + reactionsSegmentName;
        }
        String _fullyQualifiedName_5 = fullyQualifiedName;
        String _formattedName = ReactionsLanguageUtil.getFormattedName(routine);
        String _plus = "::" + _formattedName;
        fullyQualifiedName = _fullyQualifiedName_5 + _plus;
        return fullyQualifiedName;
    }

    public static String getDisplayName(Routine routine) {
        boolean _isOverride = ReactionsLanguageUtil.isOverride(routine);
        if (_isOverride) {
            return ReactionsLanguageUtil.getFullyQualifiedName(routine);
        }
        return ReactionsLanguageUtil.getFormattedName(routine);
    }

    public static boolean isRegular(Reaction reaction) {
        boolean _isOverride = ReactionsLanguageUtil.isOverride(reaction);
        return !_isOverride;
    }

    public static boolean isOverride(Reaction reaction) {
        return reaction.eIsSet((EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__OVERRIDDEN_REACTIONS_SEGMENT);
    }

    public static Iterable<Reaction> getRegularReactions(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.isRegular(it);
        return IterableExtensions.filter(reactionsSegment.getReactions(), (Functions.Function1)_function);
    }

    public static Iterable<Reaction> getOverrideReactions(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.isOverride(it);
        return IterableExtensions.filter(reactionsSegment.getReactions(), (Functions.Function1)_function);
    }

    public static boolean isRegular(Routine routine) {
        boolean _isOverride = ReactionsLanguageUtil.isOverride(routine);
        return !_isOverride;
    }

    public static boolean isOverride(Routine routine) {
        RoutineOverrideImportPath _overrideImportPath = routine.getOverrideImportPath();
        return _overrideImportPath != null;
    }

    public static Iterable<Routine> getRegularRoutines(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.isRegular(it);
        return IterableExtensions.filter(reactionsSegment.getRoutines(), (Functions.Function1)_function);
    }

    public static Iterable<Routine> getOverrideRoutines(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.isOverride(it);
        return IterableExtensions.filter(reactionsSegment.getRoutines(), (Functions.Function1)_function);
    }

    public static ReactionsImportPath toReactionsImportPath(RoutineOverrideImportPath routineOverrideImportPath) {
        if (routineOverrideImportPath == null) {
            return null;
        }
        Functions.Function1 _function = it -> {
            boolean _isNullOrEmpty;
            ReactionsSegment segment = it.getReactionsSegment();
            String _name = null;
            if (segment != null) {
                _name = segment.getName();
            }
            if (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) {
                return "<unresolved>";
            }
            return segment.getName();
        };
        List fullPathSegments = ListExtensions.map(ReactionsLanguageUtil.getFullPath(routineOverrideImportPath), (Functions.Function1)_function);
        return ReactionsImportPath.create((Iterable)fullPathSegments);
    }

    public static List<RoutineOverrideImportPath> getFullPath(RoutineOverrideImportPath routineOverrideImportPath) {
        if (routineOverrideImportPath == null) {
            return null;
        }
        ArrayList<RoutineOverrideImportPath> pathSegments = new ArrayList<RoutineOverrideImportPath>();
        for (RoutineOverrideImportPath currentPath = routineOverrideImportPath; currentPath != null; currentPath = currentPath.getParent()) {
            pathSegments.add(currentPath);
        }
        return ListExtensions.reverse(pathSegments);
    }

    private ReactionsLanguageUtil() {
    }
}

