/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.dsls.common.elements.ElementsPackage;
import tools.vitruv.dsls.common.elements.MetaclassEReferenceReference;
import tools.vitruv.dsls.common.elements.MetaclassReference;
import tools.vitruv.dsls.common.elements.NamedMetaclassReference;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsElementsCompletionChecker;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsImportsHelper;
import tools.vitruv.dsls.reactions.codegen.helper.ReactionsLanguageHelper;
import tools.vitruv.dsls.reactions.language.ElementChangeType;
import tools.vitruv.dsls.reactions.language.ElementInsertionInListChangeType;
import tools.vitruv.dsls.reactions.language.ElementReferenceChangeType;
import tools.vitruv.dsls.reactions.language.ElementRemovalFromListChangeType;
import tools.vitruv.dsls.reactions.language.LanguagePackage;
import tools.vitruv.dsls.reactions.language.ModelElementChange;
import tools.vitruv.dsls.reactions.language.RetrieveModelElement;
import tools.vitruv.dsls.reactions.language.toplevelelements.CreateBlock;
import tools.vitruv.dsls.reactions.language.toplevelelements.NamedJavaElementReference;
import tools.vitruv.dsls.reactions.language.toplevelelements.Reaction;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsFile;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsImport;
import tools.vitruv.dsls.reactions.language.toplevelelements.ReactionsSegment;
import tools.vitruv.dsls.reactions.language.toplevelelements.Routine;
import tools.vitruv.dsls.reactions.language.toplevelelements.TopLevelElementsPackage;
import tools.vitruv.dsls.reactions.runtime.structure.ReactionsImportPath;
import tools.vitruv.dsls.reactions.scoping.ReactionsImportScopeHelper;
import tools.vitruv.dsls.reactions.util.ReactionsLanguageUtil;
import tools.vitruv.dsls.reactions.validation.AbstractReactionsLanguageValidator;

public class ReactionsLanguageValidator
extends AbstractReactionsLanguageValidator {
    @Inject
    private ReactionsImportScopeHelper reactionsImportScopeHelper;

    @Check
    public void checkReactionsFile(ReactionsFile reactionsFile) {
        HashMap<String, ReactionsSegment> alreadyCheckedSegments = new HashMap<String, ReactionsSegment>();
        EList<ReactionsSegment> _reactionsSegments = reactionsFile.getReactionsSegments();
        for (ReactionsSegment reactionsSegment : _reactionsSegments) {
            String reactionsSegmentName = ReactionsLanguageUtil.getFormattedName(reactionsSegment);
            ReactionsSegment _putIfAbsent = alreadyCheckedSegments.putIfAbsent(reactionsSegmentName, reactionsSegment);
            boolean _tripleNotEquals = _putIfAbsent != null;
            if (!_tripleNotEquals) continue;
            String errorMessage = "Duplicate reactions segment name: " + reactionsSegmentName;
            this.error(errorMessage, reactionsSegment, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_SEGMENT__NAME);
            ReactionsSegment duplicateNameSegment = (ReactionsSegment)alreadyCheckedSegments.get(reactionsSegmentName);
            this.error(errorMessage, duplicateNameSegment, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_SEGMENT__NAME);
        }
    }

    @Check
    public void checkReactionsSegment(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function;
        boolean _isLowerCase;
        boolean _not;
        String segmentName = reactionsSegment.getName();
        String segmentFormattedName = ReactionsLanguageUtil.getFormattedName(reactionsSegment);
        boolean _startsWith = segmentName.startsWith("_");
        if (_startsWith) {
            this.error("Reactions segment names must not start with an underscore.", (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_SEGMENT__NAME);
        }
        boolean bl = _not = !(_isLowerCase = Character.isLowerCase(segmentName.charAt(0)));
        if (_not) {
            this.warning("Reactions segment names should start lower case.", (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_SEGMENT__NAME);
        }
        Resource resource = reactionsSegment.eResource();
        Iterable<IEObjectDescription> visibleReactionsSegmentDescs = this.reactionsImportScopeHelper.getVisibleReactionsSegmentDescriptions(reactionsSegment);
        IEObjectDescription duplicateNameSegmentDesc = (IEObjectDescription)IterableExtensions.findFirst(visibleReactionsSegmentDescs, (Functions.Function1)(_function = it -> ReactionsLanguageUtil.getFormattedReactionsSegmentName(it.getName().toString()).equals(segmentFormattedName)));
        if (duplicateNameSegmentDesc != null) {
            URI pathToOtherSegment = duplicateNameSegmentDesc.getEObjectURI().trimFragment().deresolve(resource.getURI());
            this.warning("Duplicate reactions segment name '" + segmentFormattedName + "': Already defined in " + String.valueOf(pathToOtherSegment), reactionsSegment, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_SEGMENT__NAME);
        }
        this.checkNoDifferentMetamodelPairImports(reactionsSegment);
        this.checkNoDuplicateImports(reactionsSegment);
        this.checkNoCyclicImports(reactionsSegment);
        this.checkNoDuplicateIncludedReactions(reactionsSegment);
        this.checkNoIncludedRoutinesNameClashes(reactionsSegment);
        this.checkNoIncludedRoutinesFacadesNameClashes(reactionsSegment);
        this.checkNoDuplicateReactionNames(reactionsSegment);
        this.checkNoDuplicateReactionNamesInIncludedReactions(reactionsSegment);
        this.checkNoDuplicateRoutineNames(reactionsSegment);
    }

    private void checkNoDifferentMetamodelPairImports(ReactionsSegment reactionsSegment) {
        String metamodelPairName = ReactionsLanguageUtil.getFormattedMetamodelPair(reactionsSegment);
        Functions.Function1 _function = it -> {
            boolean _isRoutinesOnly = it.isRoutinesOnly();
            return !_isRoutinesOnly;
        };
        Iterable _filter = IterableExtensions.filter(reactionsSegment.getReactionsImports(), (Functions.Function1)_function);
        for (ReactionsImport reactionsImport : _filter) {
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            String importedMetamodelPairName = ReactionsLanguageUtil.getFormattedMetamodelPair(importedSegment);
            boolean _equals = metamodelPairName.equals(importedMetamodelPairName);
            boolean _not = !_equals;
            if (!_not) continue;
            String errorMessage = "Cannot import reactions segment using a different metamodel pair: " + importedMetamodelPairName;
            this.error(errorMessage, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
        }
    }

    private void checkNoDuplicateImports(ReactionsSegment reactionsSegment) {
        HashMap<String, ReactionsImport> alreadyCheckedImports = new HashMap<String, ReactionsImport>();
        EList<ReactionsImport> _reactionsImports = reactionsSegment.getReactionsImports();
        for (ReactionsImport reactionsImport : _reactionsImports) {
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            String importedSegmentFormattedName = ReactionsLanguageUtil.getFormattedName(importedSegment);
            ReactionsImport duplicateImport = alreadyCheckedImports.putIfAbsent(importedSegmentFormattedName, reactionsImport);
            if (duplicateImport == null) continue;
            String errorMessage = "Duplicate reactions import: " + importedSegmentFormattedName;
            this.error(errorMessage, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
            this.error(errorMessage, duplicateImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
        }
    }

    private void checkNoCyclicImports(ReactionsSegment reactionsSegment) {
        String segmentFormattedName = ReactionsLanguageUtil.getFormattedName(reactionsSegment);
        EList<ReactionsImport> _reactionsImports = reactionsSegment.getReactionsImports();
        for (ReactionsImport reactionsImport : _reactionsImports) {
            Functions.Function1 _function;
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            Collection<ReactionsSegment> importImportedSegments = ReactionsImportsHelper.getRoutinesImportHierarchy(importedSegment).values();
            ReactionsSegment _findFirst = (ReactionsSegment)IterableExtensions.findFirst(importImportedSegments, (Functions.Function1)(_function = it -> ReactionsLanguageUtil.getFormattedName(it).equals(segmentFormattedName)));
            boolean _tripleNotEquals = _findFirst != null;
            if (!_tripleNotEquals) continue;
            String errorMessage = "Cyclic reactions import! Cannot transitively import self: " + segmentFormattedName;
            this.error(errorMessage, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
        }
    }

    private void checkNoDuplicateIncludedReactions(ReactionsSegment reactionsSegment) {
        HashMap<String, ReactionsImport> alreadyCheckedIncludedReactions = new HashMap<String, ReactionsImport>();
        Functions.Function1 _function = it -> {
            boolean _isRoutinesOnly = it.isRoutinesOnly();
            return !_isRoutinesOnly;
        };
        Iterable _filter = IterableExtensions.filter(reactionsSegment.getReactionsImports(), (Functions.Function1)_function);
        for (ReactionsImport reactionsImport : _filter) {
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            Collection<ReactionsSegment> importIncludedReactionsSegments = ReactionsImportsHelper.getReactionsImportHierarchy(importedSegment).values();
            for (ReactionsSegment includedReactionsSegment : importIncludedReactionsSegments) {
                String includedReactionsSegmentFormattedName = ReactionsLanguageUtil.getFormattedName(includedReactionsSegment);
                ReactionsImport duplicateReactionsImport = alreadyCheckedIncludedReactions.putIfAbsent(includedReactionsSegmentFormattedName, reactionsImport);
                if (duplicateReactionsImport == null) continue;
                String errorMessage = "Cannot (possibly transitively) import reactions of the same reactions segment ('" + includedReactionsSegmentFormattedName + "') more than once. Consider importing only the routines for one of them.";
                this.error(errorMessage, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
                this.error(errorMessage, duplicateReactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
            }
        }
    }

    private void checkNoDuplicateReactionNamesInIncludedReactions(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.getFormattedName(it);
        Map localReactions = IterableExtensions.toMap(ReactionsLanguageUtil.getRegularReactions(reactionsSegment), (Functions.Function1)_function);
        Functions.Function2 _function_1 = (importPath, segment) -> {
            int _length = importPath.getLength();
            return _length > 1;
        };
        Functions.Function1 _function_2 = it -> ReactionsLanguageUtil.getRegularReactions(it);
        Iterable importedReactions = Iterables.concat((Iterable)IterableExtensions.map(MapExtensions.filter(ReactionsImportsHelper.getReactionsImportHierarchy(reactionsSegment), (Functions.Function2)_function_1).values(), (Functions.Function1)_function_2));
        for (Reaction importedReaction : importedReactions) {
            String importedReactionName = ReactionsLanguageUtil.getFormattedName(importedReaction);
            Reaction duplicateReaction = (Reaction)localReactions.get(importedReactionName);
            if (duplicateReaction == null) continue;
            String _formattedName = ReactionsLanguageUtil.getFormattedName(importedReaction.getReactionsSegment());
            String _plus = "A reaction with this name ('" + importedReactionName + "') already exists in segment '" + _formattedName;
            String errorMessage = _plus + "'. Consider using a different name.";
            this.warning(errorMessage, duplicateReaction, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__NAME);
        }
    }

    private void checkNoIncludedRoutinesNameClashes(ReactionsSegment reactionsSegment) {
        Functions.Function1 _function = it -> ReactionsLanguageUtil.getFormattedName(it);
        Map localRoutines = IterableExtensions.toMap(ReactionsLanguageUtil.getRegularRoutines(reactionsSegment), (Functions.Function1)_function);
        HashMap<String, ReactionsImport> alreadyCheckedIncludedRoutines = new HashMap<String, ReactionsImport>();
        Functions.Function1 _function_1 = it -> {
            boolean _isUseQualifiedNames = it.isUseQualifiedNames();
            return !_isUseQualifiedNames;
        };
        Iterable _filter = IterableExtensions.filter(reactionsSegment.getReactionsImports(), (Functions.Function1)_function_1);
        for (ReactionsImport reactionsImport : _filter) {
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            Set<Routine> importIncludedRoutines = ReactionsImportsHelper.getIncludedRoutines(importedSegment, true, false).keySet();
            for (Routine includedRoutine : importIncludedRoutines) {
                ReactionsImport duplicateReactionsImport;
                String includedRoutineName = ReactionsLanguageUtil.getFormattedName(includedRoutine);
                Routine duplicateRoutine = (Routine)localRoutines.get(includedRoutineName);
                if (duplicateRoutine != null) {
                    String errorMessage = "Name-clash between imported and local routine ('" + includedRoutineName + "'). Consider importing using qualified names.";
                    this.error(errorMessage, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
                    this.error(errorMessage, duplicateRoutine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
                }
                if ((duplicateReactionsImport = alreadyCheckedIncludedRoutines.putIfAbsent(includedRoutineName, reactionsImport)) == null) continue;
                String errorMessage_1 = "Name-clash between imported routines ('" + includedRoutineName + "'). Consider importing one of them using qualified names.";
                this.error(errorMessage_1, reactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
                this.error(errorMessage_1, duplicateReactionsImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
            }
        }
    }

    private void checkNoIncludedRoutinesFacadesNameClashes(ReactionsSegment reactionsSegment) {
        HashMap<String, ReactionsImport> alreadyCheckedIncludedRoutinesFacades = new HashMap<String, ReactionsImport>();
        EList<ReactionsImport> _reactionsImports = reactionsSegment.getReactionsImports();
        for (ReactionsImport reactionsImport : _reactionsImports) {
            ReactionsSegment importedSegment = reactionsImport.getImportedReactionsSegment();
            boolean _isUseQualifiedNames = reactionsImport.isUseQualifiedNames();
            if (_isUseQualifiedNames) {
                String includedRoutinesFacadeName = ReactionsLanguageUtil.getFormattedName(importedSegment);
                ReactionsImport duplicateReactionsImport = alreadyCheckedIncludedRoutinesFacades.putIfAbsent(includedRoutinesFacadeName, reactionsImport);
                if (duplicateReactionsImport == null) continue;
                this.errorIncludedRoutinesFacadesNameClash(reactionsImport, duplicateReactionsImport, includedRoutinesFacadeName);
                continue;
            }
            Set<ReactionsSegment> importIncludedRoutinesFacadeSegments = ReactionsImportsHelper.getIncludedRoutinesFacades(importedSegment).keySet();
            for (ReactionsSegment includedRoutinesFacadeSegment : importIncludedRoutinesFacadeSegments) {
                String includedRoutinesFacadeName_1 = ReactionsLanguageUtil.getFormattedName(includedRoutinesFacadeSegment);
                ReactionsImport duplicateReactionsImport_1 = alreadyCheckedIncludedRoutinesFacades.putIfAbsent(includedRoutinesFacadeName_1, reactionsImport);
                if (duplicateReactionsImport_1 == null) continue;
                this.errorIncludedRoutinesFacadesNameClash(reactionsImport, duplicateReactionsImport_1, includedRoutinesFacadeName_1);
            }
        }
    }

    private void errorIncludedRoutinesFacadesNameClash(ReactionsImport checkedImport, ReactionsImport conflictingImport, String conflictingSegmentName) {
        String errorMessage = "Name-clash between routines imported (possibly transitively) with qualified names ('" + conflictingSegmentName + "'). Consider importing one of them without qualified names.";
        this.error(errorMessage, checkedImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
        this.error(errorMessage, conflictingImport, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTIONS_IMPORT__IMPORTED_REACTIONS_SEGMENT);
    }

    private void checkNoDuplicateReactionNames(ReactionsSegment reactionsSegment) {
        HashMap<String, Reaction> alreadyCheckedReactions = new HashMap<String, Reaction>();
        EList<Reaction> _reactions = reactionsSegment.getReactions();
        for (Reaction reaction : _reactions) {
            String reactionName = ReactionsLanguageUtil.getDisplayName(reaction);
            Reaction _putIfAbsent = alreadyCheckedReactions.putIfAbsent(reactionName, reaction);
            boolean _tripleNotEquals = _putIfAbsent != null;
            if (!_tripleNotEquals) continue;
            String errorMessage = "Duplicate reaction name: " + reactionName;
            this.error(errorMessage, reaction, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__NAME);
            this.error(errorMessage, (EObject)alreadyCheckedReactions.get(reactionName), (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__NAME);
        }
    }

    private void checkNoDuplicateRoutineNames(ReactionsSegment reactionsSegment) {
        HashMap<String, Routine> alreadyCheckedRoutines = new HashMap<String, Routine>();
        EList<Routine> _routines = reactionsSegment.getRoutines();
        for (Routine routine : _routines) {
            String routineName = ReactionsLanguageUtil.getDisplayName(routine);
            Routine _putIfAbsent = alreadyCheckedRoutines.putIfAbsent(routineName, routine);
            boolean _tripleNotEquals = _putIfAbsent != null;
            if (!_tripleNotEquals) continue;
            String errorMessage = "Duplicate routine name: " + routineName;
            this.error(errorMessage, routine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
            Routine duplicateNameRoutine = (Routine)alreadyCheckedRoutines.get(routineName);
            this.error(errorMessage, duplicateNameRoutine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
        }
    }

    @Check
    public void checkRetrieveElementName(RetrieveModelElement element) {
        if (!StringExtensions.isNullOrEmpty((String)element.getName()) && element.getName().startsWith("_")) {
            this.error("Element names must not start with an underscore.", (EStructuralFeature)LanguagePackage.Literals.RETRIEVE_MODEL_ELEMENT__NAME);
        }
    }

    @Check
    public void checkCreateElementName(CreateBlock createBlock) {
        EList<NamedMetaclassReference> _createStatements = createBlock.getCreateStatements();
        for (NamedMetaclassReference element : _createStatements) {
            if (StringExtensions.isNullOrEmpty((String)element.getName()) || !element.getName().startsWith("_")) continue;
            this.error("Element names must not start with an underscore.", (EStructuralFeature)ElementsPackage.Literals.NAMED_METACLASS_REFERENCE__NAME);
        }
    }

    @Check
    public void checkRoutine(Routine routine) {
        boolean _isOverride;
        boolean _isLowerCase;
        boolean _not;
        boolean _startsWith = routine.getName().startsWith("_");
        if (_startsWith) {
            this.error("Routine names must not start with an underscore.", (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
        }
        boolean bl = _not = !(_isLowerCase = Character.isLowerCase(routine.getName().charAt(0)));
        if (_not) {
            this.warning("Routine names should start lower case", (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
        }
        if (_isOverride = ReactionsLanguageUtil.isOverride(routine)) {
            boolean _not_1;
            ReactionsImportPath overrideImportPath = ReactionsLanguageUtil.toReactionsImportPath(routine.getOverrideImportPath());
            boolean _isComplete = ReactionsElementsCompletionChecker.isComplete(routine.getOverrideImportPath());
            boolean bl2 = _not_1 = !_isComplete;
            if (_not_1) {
                String _pathString = overrideImportPath.getPathString();
                String errorMessage = "Incomplete override import path: " + _pathString;
                this.error(errorMessage, routine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__OVERRIDE_IMPORT_PATH);
            } else {
                ReactionsSegment overriddenReactionsSegment = ReactionsImportsHelper.getReactionsSegment(routine.getReactionsSegment(), overrideImportPath);
                if (overriddenReactionsSegment == null) {
                    String _pathString_1 = overrideImportPath.getPathString();
                    String errorMessage_1 = "Can not find overridden reactions segment for this import path: " + _pathString_1;
                    this.error(errorMessage_1, routine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__OVERRIDE_IMPORT_PATH);
                } else {
                    String routineName = ReactionsLanguageUtil.getFormattedName(routine);
                    Functions.Function1 _function = it -> ReactionsLanguageUtil.getFormattedName(it).equals(routineName);
                    Routine overriddenRoutine = (Routine)IterableExtensions.findFirst(ReactionsLanguageUtil.getRegularRoutines(overriddenReactionsSegment), (Functions.Function1)_function);
                    if (overriddenRoutine == null) {
                        String errorMessage_2 = "Routine name does not match any routine in the overridden reactions segment: " + routineName;
                        this.error(errorMessage_2, routine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__NAME);
                    } else {
                        boolean _not_2;
                        String overriddenInputSignature;
                        String inputSignature = this.getInputSignature(routine);
                        boolean _equals = inputSignature.equals(overriddenInputSignature = this.getInputSignature(overriddenRoutine));
                        boolean bl3 = _not_2 = !_equals;
                        if (_not_2) {
                            String errorMessage_3 = "Input parameters need to match those of the overridden routine: " + overriddenInputSignature;
                            this.error(errorMessage_3, routine, (EStructuralFeature)TopLevelElementsPackage.Literals.ROUTINE__INPUT);
                        }
                    }
                }
            }
        }
    }

    private String getInputSignature(Routine routine) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        EList<NamedMetaclassReference> _modelInputElements = routine.getInput().getModelInputElements();
        for (NamedMetaclassReference modelInputElement : _modelInputElements) {
            signature.append(ReactionsLanguageHelper.getJavaClassName(modelInputElement.getMetaclass()));
        }
        EList<NamedJavaElementReference> _javaInputElements = routine.getInput().getJavaInputElements();
        for (NamedJavaElementReference javaInputElement : _javaInputElements) {
            signature.append(javaInputElement.getType().getIdentifier());
        }
        signature.append(")");
        return signature.toString();
    }

    @Check
    public void checkReaction(Reaction reaction) {
        boolean _isOverride;
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(reaction.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.warning("Reaction names should start upper case", (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__NAME);
        }
        if (_isOverride = ReactionsLanguageUtil.isOverride(reaction)) {
            String reactionName = ReactionsLanguageUtil.getFormattedName(reaction);
            Functions.Function1 _function = it -> ReactionsLanguageUtil.getFormattedName(it).equals(reactionName);
            Reaction overriddenReaction = (Reaction)IterableExtensions.findFirst(ReactionsLanguageUtil.getRegularReactions(reaction.getOverriddenReactionsSegment()), (Functions.Function1)_function);
            if (overriddenReaction == null) {
                String errorMessage = "Reaction name does not match any reaction in the overridden reactions segment: " + reactionName;
                this.error(errorMessage, reaction, (EStructuralFeature)TopLevelElementsPackage.Literals.REACTION__NAME);
            }
        }
    }

    @Check
    public void checkMetaclassFeature(ModelElementChange elementChange) {
        MetaclassReference _elementType = null;
        if (elementChange != null) {
            _elementType = elementChange.getElementType();
        }
        EClassifier _metaclass = null;
        if (_elementType != null) {
            _metaclass = _elementType.getMetaclass();
        }
        EClass elementType = (EClass)_metaclass;
        ElementChangeType _changeType = null;
        if (elementChange != null) {
            _changeType = elementChange.getChangeType();
        }
        ElementChangeType elementChangeType = _changeType;
        ElementChangeType atomicChangeType = null;
        if (elementChangeType instanceof ElementReferenceChangeType) {
            atomicChangeType = elementChangeType;
        }
        if (atomicChangeType instanceof ElementReferenceChangeType) {
            MetaclassEReferenceReference _feature = ((ElementReferenceChangeType)((Object)atomicChangeType)).getFeature();
            EReference _feature_1 = null;
            if (_feature != null) {
                _feature_1 = _feature.getFeature();
            }
            EClassifier _eType = null;
            if (_feature_1 != null) {
                _eType = _feature_1.getEType();
            }
            EClass featureType = (EClass)_eType;
            if (!(elementType == null || featureType == null || elementType.equals(featureType) || elementType.getEAllSuperTypes().contains((Object)featureType) || featureType.getEAllSuperTypes().contains((Object)elementType))) {
                this.error("Element of specified type cannot be contained in the specified features", elementChange, (EStructuralFeature)LanguagePackage.Literals.MODEL_ELEMENT_CHANGE__ELEMENT_TYPE);
            }
        }
        if (atomicChangeType instanceof ElementReferenceChangeType) {
            EReference featureVal;
            MetaclassEReferenceReference _feature_2 = ((ElementReferenceChangeType)((Object)atomicChangeType)).getFeature();
            EReference _feature_3 = null;
            if (_feature_2 != null) {
                _feature_3 = _feature_2.getFeature();
            }
            if ((featureVal = _feature_3) instanceof ETypedElement) {
                boolean _not;
                boolean _isMany = featureVal.isMany();
                boolean bl = _not = !_isMany;
                if (_not) {
                    if (elementChangeType instanceof ElementInsertionInListChangeType) {
                        this.error("Element cannot be inserted into single valued reference", elementChange, (EStructuralFeature)LanguagePackage.Literals.MODEL_ELEMENT_CHANGE__CHANGE_TYPE);
                    } else if (elementChangeType instanceof ElementRemovalFromListChangeType) {
                        this.error("Element cannot be removed from single valued reference", elementChange, (EStructuralFeature)LanguagePackage.Literals.MODEL_ELEMENT_CHANGE__CHANGE_TYPE);
                    }
                }
            }
        }
    }
}

