/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.runtime.helper;

import edu.kit.ipd.sdq.activextendannotations.Utility;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import tools.vitruv.change.utils.ProjectMarker;

@Utility
public final class PersistenceHelper {
    private static URI getURIOfElementProject(EObject element) {
        URI elementUri = element.eResource().getURI();
        boolean _isPlatform = elementUri.isPlatform();
        if (_isPlatform) {
            IFile sourceModelFile = URIUtil.getIFileForEMFUri((URI)elementUri);
            IProject projectSourceModel = sourceModelFile.getProject();
            String srcFolderPath = projectSourceModel.getFullPath().toString();
            return URI.createPlatformResourceURI((String)srcFolderPath, (boolean)true);
        }
        boolean _isFile = elementUri.isFile();
        if (_isFile) {
            Path elementPath = Path.of(elementUri.toFileString(), new String[0]);
            return URIUtil.createFileURI((File)ProjectMarker.getProjectRootFolder((Path)elementPath).toFile());
        }
        throw new UnsupportedOperationException("Other URI types than file and platform are currently not supported");
    }

    private static URI appendPathToURI(URI baseURI, String relativePath) {
        boolean _not;
        String[] newModelFileSegments = relativePath.split("/");
        boolean _contains = ((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)newModelFileSegments)))).contains(".");
        boolean bl = _not = !_contains;
        if (_not) {
            throw new IllegalArgumentException("File extension must be specified");
        }
        return baseURI.appendSegments(newModelFileSegments);
    }

    public static URI getURIFromSourceProjectFolder(EObject source, String relativePath) {
        URI baseURI = PersistenceHelper.getURIOfElementProject(source);
        return PersistenceHelper.appendPathToURI(baseURI, relativePath);
    }

    private PersistenceHelper() {
    }
}

