/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.runtime.reactions;

import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.correspondence.Correspondence;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.change.interaction.UserInteractor;
import tools.vitruv.change.propagation.ChangePropagationObservable;
import tools.vitruv.change.propagation.impl.AbstractChangePropagationSpecification;
import tools.vitruv.change.utils.ResourceAccess;
import tools.vitruv.dsls.reactions.runtime.correspondence.CorrespondenceFactory;
import tools.vitruv.dsls.reactions.runtime.correspondence.ReactionsCorrespondence;
import tools.vitruv.dsls.reactions.runtime.reactions.Reaction;
import tools.vitruv.dsls.reactions.runtime.state.ReactionExecutionState;

public abstract class AbstractReactionsChangePropagationSpecification
extends AbstractChangePropagationSpecification {
    private static final Logger LOGGER = LogManager.getLogger(AbstractReactionsChangePropagationSpecification.class);
    private final List<Reaction> reactions = CollectionLiterals.newArrayList();

    public AbstractReactionsChangePropagationSpecification(MetamodelDescriptor sourceMetamodelDescriptor, MetamodelDescriptor targetMetamodelDescriptor) {
        super(sourceMetamodelDescriptor, targetMetamodelDescriptor);
        this.setup();
    }

    protected void addReaction(Reaction reaction) {
        this.reactions.add(reaction);
    }

    public boolean doesHandleChange(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel) {
        return true;
    }

    public void propagateChange(EChange<EObject> change, EditableCorrespondenceModelView<Correspondence> correspondenceModel, ResourceAccess resourceAccess) {
        MetamodelDescriptor _sourceMetamodelDescriptor = this.getSourceMetamodelDescriptor();
        String _plus = "Call relevant reactions from " + String.valueOf(_sourceMetamodelDescriptor);
        String _plus_1 = _plus + " to ";
        MetamodelDescriptor _targetMetamodelDescriptor = this.getTargetMetamodelDescriptor();
        String _plus_2 = _plus_1 + String.valueOf(_targetMetamodelDescriptor);
        LOGGER.trace(_plus_2);
        for (Reaction reaction : this.reactions) {
            String _simpleName = reaction.getClass().getSimpleName();
            String _plus_3 = "Calling reaction: " + _simpleName;
            String _plus_4 = _plus_3 + " with change: ";
            String _plus_5 = _plus_4 + String.valueOf(change);
            LOGGER.trace(_plus_5);
            UserInteractor _userInteractor = this.getUserInteractor();
            EditableCorrespondenceModelView<ReactionsCorrespondence> _reactionsView = AbstractReactionsChangePropagationSpecification.getReactionsView(correspondenceModel);
            ReactionExecutionState executionState = new ReactionExecutionState(_userInteractor, _reactionsView, resourceAccess, (ChangePropagationObservable)this);
            reaction.execute(change, executionState);
        }
    }

    private static EditableCorrespondenceModelView<ReactionsCorrespondence> getReactionsView(EditableCorrespondenceModelView<Correspondence> correspondenceModel) {
        Supplier<ReactionsCorrespondence> _function = () -> CorrespondenceFactory.eINSTANCE.createReactionsCorrespondence();
        return correspondenceModel.getEditableView(ReactionsCorrespondence.class, _function);
    }

    public void setUserInteractor(UserInteractor userInteractor) {
        super.setUserInteractor(userInteractor);
        this.reactions.clear();
        this.setup();
    }

    protected abstract void setup();
}

