/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.runtime.routines;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.dsls.reactions.runtime.correspondence.ReactionsCorrespondence;
import tools.vitruv.dsls.reactions.runtime.helper.PersistenceHelper;
import tools.vitruv.dsls.reactions.runtime.routines.AbstractRoutinesFacade;
import tools.vitruv.dsls.reactions.runtime.routines.Routine;
import tools.vitruv.dsls.reactions.runtime.state.ReactionExecutionState;
import tools.vitruv.dsls.reactions.runtime.structure.CallHierarchyHaving;
import tools.vitruv.dsls.reactions.runtime.structure.Loggable;

public abstract class AbstractRoutine
extends CallHierarchyHaving
implements Routine {
    private final AbstractRoutinesFacade routinesFacade;
    @Extension
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private final ReactionExecutionState executionState;

    public AbstractRoutine(AbstractRoutinesFacade routinesFacade, ReactionExecutionState executionState, CallHierarchyHaving calledBy) {
        super(calledBy);
        this.routinesFacade = routinesFacade;
        this.executionState = executionState;
    }

    protected <T extends AbstractRoutinesFacade> T getRoutinesFacade() {
        return (T)this.routinesFacade;
    }

    @Override
    public boolean execute() {
        this.routinesFacade._pushCaller(this);
        try {
            boolean bl = this.executeRoutine();
            this.routinesFacade._dropLastCaller();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.routinesFacade._dropLastCaller();
                throw throwable;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    protected abstract boolean executeRoutine() throws IOException;

    @Pure
    protected ReactionExecutionState getExecutionState() {
        return this.executionState;
    }

    public static class Update
    extends CorrespondenceRetriever {
        @Extension
        protected final ReactionExecutionState executionState;

        public Update(ReactionExecutionState executionState) {
            super(executionState.getCorrespondenceModel());
            this.executionState = executionState;
        }

        protected void persistProjectRelative(EObject alreadyPersistedObject, EObject elementToPersist, String persistencePath) {
            if (alreadyPersistedObject == null || elementToPersist == null || persistencePath == null) {
                throw new IllegalArgumentException("correspondenceSource, element and persistancePath must be specified");
            }
            URI _resourceURI = PersistenceHelper.getURIFromSourceProjectFolder(alreadyPersistedObject, persistencePath);
            this.persistAsRoot(elementToPersist, _resourceURI);
        }

        private void persistAsRoot(EObject rootObject, URI uri) {
            boolean _tripleNotEquals;
            this.getLogger().trace("Registered to persist root " + String.valueOf(rootObject) + " in: " + String.valueOf(uri));
            Resource _eResource = rootObject.eResource();
            URI _uRI = null;
            if (_eResource != null) {
                _uRI = _eResource.getURI();
            }
            boolean bl = _tripleNotEquals = _uRI != uri;
            if (_tripleNotEquals) {
                EcoreUtil.remove((EObject)rootObject);
                this.executionState.getResourceAccess().persistAsRoot(rootObject, uri);
            }
        }

        protected void addCorrespondenceBetween(EObject firstElement, EObject secondElement) {
            this.addCorrespondenceBetween(firstElement, secondElement, null);
        }

        protected void addCorrespondenceBetween(EObject firstElement, EObject secondElement, String tag) {
            String _elvis = null;
            _elvis = tag != null ? tag : "";
            this.executionState.getCorrespondenceModel().addCorrespondenceBetween(firstElement, secondElement, _elvis);
        }

        public void removeObject(EObject element) {
            if (element == null) {
                return;
            }
            boolean _isDebugEnabled = this.getLogger().isDebugEnabled();
            if (_isDebugEnabled) {
                Logger _logger = this.getLogger();
                EObject _eContainer = element.eContainer();
                String _plus = "Removing object " + String.valueOf(element) + " from container " + String.valueOf(_eContainer);
                _logger.debug(_plus);
            }
            EcoreUtil.remove((EObject)element);
        }

        protected void removeCorrespondenceBetween(EObject firstElement, EObject secondElement) {
            this.removeCorrespondenceBetween(firstElement, secondElement, null);
        }

        protected void removeCorrespondenceBetween(EObject firstElement, EObject secondElement, String tag) {
            this.executionState.getCorrespondenceModel().removeCorrespondencesBetween(firstElement, secondElement, tag);
        }
    }

    public static class Create
    extends Loggable {
        @Extension
        protected final ReactionExecutionState executionState;

        public Create(ReactionExecutionState executionState) {
            this.executionState = executionState;
        }

        protected <T extends EObject> T createObject(Functions.Function0<? extends T> creator) {
            EObject createdObject = (EObject)creator.apply();
            this.notifyObjectCreated(createdObject);
            return (T)createdObject;
        }

        private void notifyObjectCreated(EObject createdObject) {
            this.executionState.getChangePropagationObservable().notifyObjectCreated(createdObject);
        }
    }

    public static class Match
    extends CorrespondenceRetriever {
        @Extension
        protected final ReactionExecutionState executionState;

        public Match(ReactionExecutionState executionState) {
            super(executionState.getCorrespondenceModel());
            this.executionState = executionState;
        }
    }

    private static class CorrespondenceRetriever
    extends Loggable {
        private EditableCorrespondenceModelView<ReactionsCorrespondence> _correspondenceModel;

        public CorrespondenceRetriever(EditableCorrespondenceModelView<ReactionsCorrespondence> correspondenceModel) {
            this._correspondenceModel = correspondenceModel;
        }

        protected <T extends EObject> boolean hasCorrespondingElements(EObject correspondenceSource, Class<T> elementClass, Function<T, Boolean> correspondencePreconditionMethod, String tag) {
            boolean _isEmpty = IterableExtensions.isEmpty(this.getCorrespondingElements(correspondenceSource, elementClass, correspondencePreconditionMethod, tag));
            return !_isEmpty;
        }

        protected <T extends EObject> Iterable<T> getCorrespondingElements(EObject correspondenceSource, Class<T> expectedType, Function<T, Boolean> correspondencePreconditionMethod, String expectedTag) {
            Function<Object, Boolean> _elvis = null;
            if (correspondencePreconditionMethod != null) {
                _elvis = correspondencePreconditionMethod;
            } else {
                Function<EObject, Boolean> _function = it -> true;
                _elvis = _function;
            }
            final Function<T, Boolean> preconditionMethod = _elvis;
            Iterable correspondingObjects = Iterables.filter((Iterable)this._correspondenceModel.getCorrespondingEObjects(correspondenceSource, expectedTag), expectedType);
            return IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)correspondingObjects), (Functions.Function1)new Functions.Function1<T, Boolean>(){

                public Boolean apply(T arg0) {
                    return (Boolean)preconditionMethod.apply(arg0);
                }
            });
        }

        protected <T extends EObject> T getCorrespondingElement(EObject correspondenceSource, Class<T> elementClass, Function<T, Boolean> correspondencePreconditionMethod, String tag, boolean asserted) {
            Iterable<T> retrievedElements = this.getCorrespondingElements(correspondenceSource, elementClass, correspondencePreconditionMethod, tag);
            Preconditions.checkState((IterableExtensions.size(retrievedElements) <= 1 && (!asserted || IterableExtensions.size(retrievedElements) == 1) ? 1 : 0) != 0, (String)"There were (%s) corresponding elements of type %s for: %s, which are: %s", (Object)IterableExtensions.size(retrievedElements), (Object)elementClass.getSimpleName(), (Object)correspondenceSource, retrievedElements);
            EObject retrievedElement = (EObject)IterableExtensions.head(retrievedElements);
            return (T)retrievedElement;
        }
    }
}

