/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.dsls.reactions.runtime.structure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReactionsImportPath {
    public static final ReactionsImportPath EMPTY_PATH = new ReactionsImportPath(Collections.unmodifiableList(CollectionLiterals.newArrayList()));
    public static final String PATH_STRING_SEPARATOR = ".";
    private static final Pattern PATH_STRING_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("."));
    private final List<String> segments;

    public static ReactionsImportPath fromPathString(String pathString) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)pathString);
        if (_isNullOrEmpty) {
            return EMPTY_PATH;
        }
        String[] pathSegments = PATH_STRING_SEPARATOR_PATTERN.split(pathString, -1);
        return ReactionsImportPath.create(pathSegments);
    }

    public static ReactionsImportPath create(Iterable<String> pathSegments) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(pathSegments);
        if (_isNullOrEmpty) {
            return EMPTY_PATH;
        }
        return new ReactionsImportPath(pathSegments);
    }

    public static ReactionsImportPath create(String ... pathSegments) {
        return ReactionsImportPath.create((Iterable)Conversions.doWrapArray((Object)pathSegments));
    }

    public static ReactionsImportPath create(Iterable<String> parentPath, String ... pathSegments) {
        return ReactionsImportPath.create(parentPath, (Iterable)Conversions.doWrapArray((Object)pathSegments));
    }

    public static ReactionsImportPath create(Iterable<String> parentPath, Iterable<String> pathSegments) {
        Iterable<String> _elvis = null;
        _elvis = parentPath != null ? parentPath : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        Iterable<String> _elvis_1 = null;
        _elvis_1 = pathSegments != null ? pathSegments : Collections.unmodifiableList(CollectionLiterals.newArrayList());
        Iterable _plus = Iterables.concat(_elvis, _elvis_1);
        return ReactionsImportPath.create(_plus);
    }

    private ReactionsImportPath(Iterable<String> pathSegments) {
        Preconditions.checkNotNull(pathSegments, (Object)"pathSegments is null");
        this.segments = ImmutableList.copyOf(pathSegments);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public int getLength() {
        return this.segments.size();
    }

    public boolean isEmpty() {
        int _length = this.getLength();
        return _length == 0;
    }

    public String getSegment(int index) {
        return this.segments.get(index);
    }

    public String getLastSegment() {
        int _size = this.segments.size();
        int _minus = _size - 1;
        return this.segments.get(_minus);
    }

    public String getFirstSegment() {
        return this.segments.get(0);
    }

    public ReactionsImportPath append(String ... pathSegments) {
        return this.append((Iterable)Conversions.doWrapArray((Object)pathSegments));
    }

    public ReactionsImportPath append(Iterable<String> pathSegments) {
        return ReactionsImportPath.create(this.segments, pathSegments);
    }

    public ReactionsImportPath append(ReactionsImportPath path) {
        List<String> _segments = null;
        if (path != null) {
            _segments = path.segments;
        }
        return ReactionsImportPath.create(this.segments, _segments);
    }

    public ReactionsImportPath prepend(String ... pathSegments) {
        return this.prepend((Iterable)Conversions.doWrapArray((Object)pathSegments));
    }

    public ReactionsImportPath prepend(Iterable<String> pathSegments) {
        return ReactionsImportPath.create(pathSegments, this.segments);
    }

    public ReactionsImportPath prepend(ReactionsImportPath path) {
        List<String> _segments = null;
        if (path != null) {
            _segments = path.segments;
        }
        return ReactionsImportPath.create(_segments, this.segments);
    }

    public ReactionsImportPath getParent() {
        int _length = this.getLength();
        int _minus = _length - 1;
        Iterable parentPath = IterableExtensions.take(this.segments, (int)_minus);
        return ReactionsImportPath.create(parentPath);
    }

    public ReactionsImportPath relativeToRoot() {
        Iterable tailPath = IterableExtensions.tail(this.segments);
        return ReactionsImportPath.create(tailPath);
    }

    public ReactionsImportPath relativeTo(String pathSegment) {
        int index = this.segments.indexOf(pathSegment);
        if (index == -1 || index == this.getLength() - 1) {
            return EMPTY_PATH;
        }
        List<String> relativePathSegments = this.segments.subList(index + 1, this.getLength());
        return ReactionsImportPath.create(relativePathSegments);
    }

    public ReactionsImportPath subPathTo(String pathSegment) {
        int index = this.segments.indexOf(pathSegment);
        if (index == -1) {
            return EMPTY_PATH;
        }
        List<String> subPathSegments = this.segments.subList(0, index + 1);
        return ReactionsImportPath.create(subPathSegments);
    }

    public String getPathString() {
        return IterableExtensions.join(this.segments, (CharSequence)PATH_STRING_SEPARATOR);
    }

    public String toString() {
        String _pathString = this.getPathString();
        return "ReactionsImportPath=" + _pathString;
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public boolean equals(Object obj) {
        boolean _not;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactionsImportPath)) {
            return false;
        }
        ReactionsImportPath other = (ReactionsImportPath)obj;
        boolean _equals = this.segments.equals(other.segments);
        boolean bl = _not = !_equals;
        return !_not;
    }
}

