/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import tools.vitruv.framework.views.ViewType;
import tools.vitruv.framework.views.ViewTypeProvider;

public class ViewTypeRepository
implements ViewTypeProvider {
    private final Map<String, ViewType<?>> registeredViewTypes;

    public ViewTypeRepository() {
        HashMap _hashMap = new HashMap();
        this.registeredViewTypes = _hashMap;
    }

    @Override
    public Collection<ViewType<?>> getViewTypes() {
        Collection<ViewType<?>> _values = this.registeredViewTypes.values();
        return new ArrayList(_values);
    }

    public void register(ViewType<?> viewType) {
        Preconditions.checkArgument((viewType != null ? 1 : 0) != 0, (Object)"null cannot be added as a view type");
        boolean _containsKey = this.registeredViewTypes.containsKey(viewType.getName());
        boolean _not = !_containsKey;
        Preconditions.checkState((boolean)_not, (String)"view type name '%s' already taken by another view type", (Object)viewType.getName());
        this.registeredViewTypes.put(viewType.getName(), viewType);
    }

    public ViewType<?> findViewType(String viewTypeName) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)viewTypeName);
        boolean _not = !_isNullOrEmpty;
        Preconditions.checkArgument((boolean)_not, (Object)"view type name to search for must not be null or empty");
        return this.registeredViewTypes.get(viewTypeName);
    }
}

