/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.changederivation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceCopier;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceUtil;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.change.composite.recording.ChangeRecorder;
import tools.vitruv.framework.views.changederivation.StateBasedChangeResolutionStrategy;

public class DefaultStateBasedChangeResolutionStrategy
implements StateBasedChangeResolutionStrategy {
    public final UseIdentifiers useIdentifiers;

    public DefaultStateBasedChangeResolutionStrategy() {
        this(UseIdentifiers.WHEN_AVAILABLE);
    }

    public DefaultStateBasedChangeResolutionStrategy(UseIdentifiers useIdentifiers) {
        this.useIdentifiers = useIdentifiers;
    }

    private void checkNoProxies(Resource resource, String stateNotice) {
        Iterable proxies = ResourceUtil.getReferencedProxies((Resource)resource);
        Functions.Function1 _function = it -> it.toString();
        Preconditions.checkArgument((boolean)IterableExtensions.isEmpty((Iterable)proxies), (String)"%s '%s' should not contain proxies, but contains the following: %s", (Object)stateNotice, (Object)resource.getURI(), (Object)String.join((CharSequence)", ", IterableExtensions.map((Iterable)proxies, (Functions.Function1)_function)));
    }

    @Override
    public VitruviusChange<HierarchicalId> getChangeSequenceBetween(Resource newState, Resource oldState) {
        Preconditions.checkArgument((oldState != null && newState != null ? 1 : 0) != 0, (Object)"old state or new state must not be null!");
        this.checkNoProxies(newState, "new state");
        this.checkNoProxies(oldState, "old state");
        ResourceSetImpl monitoredResourceSet = new ResourceSetImpl();
        Resource currentStateCopy = ResourceCopier.copyViewResource((Resource)oldState, (ResourceSet)monitoredResourceSet);
        Procedures.Procedure0 _function = () -> {
            URI _uRI_1;
            boolean _notEquals;
            URI _uRI = oldState.getURI();
            boolean bl = _notEquals = !Objects.equals(_uRI, _uRI_1 = newState.getURI());
            if (_notEquals) {
                currentStateCopy.setURI(newState.getURI());
            }
            this.compareStatesAndReplayChanges((Notifier)newState, (Notifier)currentStateCopy);
        };
        return this.record(currentStateCopy, _function);
    }

    @Override
    public VitruviusChange<HierarchicalId> getChangeSequenceForCreated(Resource newState) {
        Preconditions.checkArgument((newState != null ? 1 : 0) != 0, (Object)"new state must not be null!");
        this.checkNoProxies(newState, "new state");
        ResourceSetImpl monitoredResourceSet = new ResourceSetImpl();
        Resource newResource = monitoredResourceSet.createResource(newState.getURI());
        newResource.getContents().clear();
        Procedures.Procedure0 _function = () -> {
            EList _contents = newResource.getContents();
            Collection _copyAll = EcoreUtil.copyAll((Collection)newState.getContents());
            Iterables.addAll((Collection)_contents, (Iterable)_copyAll);
        };
        return this.record(newResource, _function);
    }

    @Override
    public VitruviusChange<HierarchicalId> getChangeSequenceForDeleted(Resource oldState) {
        Preconditions.checkArgument((oldState != null ? 1 : 0) != 0, (Object)"old state must not be null!");
        this.checkNoProxies(oldState, "old state");
        ResourceSetImpl monitoredResourceSet = new ResourceSetImpl();
        Resource currentStateCopy = ResourceCopier.copyViewResource((Resource)oldState, (ResourceSet)monitoredResourceSet);
        Procedures.Procedure0 _function = () -> currentStateCopy.getContents().clear();
        return this.record(currentStateCopy, _function);
    }

    private <T extends Notifier> VitruviusChange<HierarchicalId> record(Resource resource, Procedures.Procedure0 function) {
        try (ChangeRecorder changeRecorder = new ChangeRecorder(resource.getResourceSet());){
            changeRecorder.beginRecording();
            changeRecorder.addToRecording((Notifier)resource);
            function.apply();
            TransactionalChange recordedChanges = changeRecorder.endRecording();
            VitruviusChangeResolver changeResolver = VitruviusChangeResolverFactory.forHierarchicalIds((ResourceSet)resource.getResourceSet());
            VitruviusChange vitruviusChange = changeResolver.assignIds((VitruviusChange)recordedChanges);
            return vitruviusChange;
        }
    }

    private void compareStatesAndReplayChanges(Notifier newState, Notifier currentState) {
        DefaultComparisonScope scope = new DefaultComparisonScope(newState, currentState, null);
        EMFCompare.Builder _builder = EMFCompare.builder();
        Procedures.Procedure1 _function = it -> {
            IMatchEngine.Factory.Registry _createStandaloneInstance = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
            Procedures.Procedure1 _function_1 = it_1 -> {
                MatchEngineFactoryImpl _matchEngineFactoryImpl = new MatchEngineFactoryImpl(this.useIdentifiers);
                it_1.add((IMatchEngine.Factory)_matchEngineFactoryImpl);
            };
            IMatchEngine.Factory.Registry _doubleArrow = (IMatchEngine.Factory.Registry)ObjectExtensions.operator_doubleArrow((Object)_createStandaloneInstance, (Procedures.Procedure1)_function_1);
            it.setMatchEngineFactoryRegistry(_doubleArrow);
        };
        EMFCompare emfCompare = ((EMFCompare.Builder)ObjectExtensions.operator_doubleArrow((Object)_builder, (Procedures.Procedure1)_function)).build();
        EList differences = emfCompare.compare((IComparisonScope)scope).getDifferences();
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        BatchMerger merger = new BatchMerger(mergerRegistry);
        BasicMonitor _basicMonitor = new BasicMonitor();
        merger.copyAllLeftToRight((Iterable)differences, (Monitor)_basicMonitor);
    }
}

