/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.propagation.ChangePropagationListener;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.CommittableView;
import tools.vitruv.framework.views.ViewSelection;
import tools.vitruv.framework.views.ViewSelector;
import tools.vitruv.framework.views.changederivation.StateBasedChangeResolutionStrategy;
import tools.vitruv.framework.views.impl.ChangeDerivingView;
import tools.vitruv.framework.views.impl.ChangeRecordingView;
import tools.vitruv.framework.views.impl.ModifiableView;
import tools.vitruv.framework.views.impl.ViewCreatingViewType;

class BasicView
implements ModifiableView,
ChangePropagationListener {
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private ViewSelection selection;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private ViewCreatingViewType<? extends ViewSelector, HierarchicalId> viewType;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private ChangeableViewSource viewSource;
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private ResourceSet viewResourceSet;
    private boolean modelChanged;
    @Accessors(value={AccessorType.PROTECTED_SETTER})
    private boolean viewChanged;
    private boolean closed;

    protected BasicView(ViewCreatingViewType<? extends ViewSelector, HierarchicalId> viewType, ChangeableViewSource viewSource, ViewSelection selection) {
        Preconditions.checkArgument((viewType != null ? 1 : 0) != 0, (Object)"view type must not be null");
        Preconditions.checkArgument((viewSource != null ? 1 : 0) != 0, (Object)"view selection must not be null");
        Preconditions.checkArgument((selection != null ? 1 : 0) != 0, (Object)"view source must not be null");
        this.viewType = viewType;
        this.viewSource = viewSource;
        this.selection = selection;
        viewSource.addChangePropagationListener(this);
        this.viewResourceSet = ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl());
        this.update();
    }

    @Override
    public Collection<EObject> getRootObjects() {
        List _xblockexpression = null;
        this.checkNotClosed();
        Functions.Function1 _function = it -> it.getContents();
        _xblockexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)this.viewResourceSet.getResources(), (Functions.Function1)_function)));
        return _xblockexpression;
    }

    @Override
    public boolean isModified() {
        return this.viewChanged;
    }

    @Override
    public boolean isOutdated() {
        return this.modelChanged;
    }

    @Override
    public void update() {
        this.checkNotClosed();
        boolean _isModified = this.isModified();
        boolean _not = !_isModified;
        Preconditions.checkState((boolean)_not, (Object)"cannot update from model when view is modified");
        this.modelChanged = false;
        this.viewType.updateView(this);
        this.viewChanged = false;
        this.addChangeListeners((Notifier)this.viewResourceSet);
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
            Consumer<Resource> _function = it -> it.unload();
            this.viewResourceSet.getResources().forEach(_function);
            this.viewResourceSet.getResources().clear();
            this.removeChangeListeners(this.viewResourceSet);
        }
        this.viewSource.removeChangePropagationListener(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void finishedChangePropagation(Iterable<PropagatedChange> propagatedChanges) {
        this.modelChanged = true;
    }

    public void startedChangePropagation(VitruviusChange<Uuid> changeToPropagate) {
    }

    @Override
    public void registerRoot(EObject object, URI persistAt) {
        this.checkNotClosed();
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object to register as root must not be null");
        Preconditions.checkArgument((persistAt != null ? 1 : 0) != 0, (Object)"URI for root to register must not be null");
        Resource _createResource = this.viewResourceSet.createResource(persistAt);
        Procedures.Procedure1 _function = it -> {
            EList _contents = it.getContents();
            _contents.add((Object)object);
        };
        ObjectExtensions.operator_doubleArrow((Object)_createResource, (Procedures.Procedure1)_function);
    }

    @Override
    public void moveRoot(EObject object, URI newLocation) {
        this.checkNotClosed();
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"object to move must not be null");
        Preconditions.checkState((boolean)this.getRootObjects().contains(object), (String)"view must contain element %s to move", (Object)object);
        Preconditions.checkArgument((newLocation != null ? 1 : 0) != 0, (Object)"URI for new location of root must not be null");
        Functions.Function1 _function = it -> it.getContents().contains((Object)object);
        Resource _findFirst = (Resource)IterableExtensions.findFirst((Iterable)this.viewResourceSet.getResources(), (Functions.Function1)_function);
        _findFirst.setURI(newLocation);
    }

    public void checkNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"view is already closed!");
    }

    private void addChangeListeners(Notifier notifier) {
        Consumer<Resource> _function;
        EList _eAdapters = notifier.eAdapters();
        _eAdapters.add((Object)new AdapterImpl(){

            public void notifyChanged(Notification message) {
                BasicView.this.viewChanged = true;
            }
        });
        boolean _matched = false;
        if (notifier instanceof ResourceSet) {
            _matched = true;
            _function = it -> this.addChangeListeners((Notifier)it);
            ((ResourceSet)notifier).getResources().forEach(_function);
        }
        if (!_matched && notifier instanceof Resource) {
            _matched = true;
            _function = it -> this.addChangeListeners((Notifier)it);
            ((Resource)notifier).getContents().forEach(_function);
        }
        if (!_matched && notifier instanceof EObject) {
            _matched = true;
            _function = it -> this.addChangeListeners((Notifier)it);
            ((EObject)notifier).eContents().forEach(_function);
        }
    }

    private void removeChangeListeners(ResourceSet resourceSet) {
        Procedures.Procedure1 _function = it -> it.eAdapters().clear();
        IteratorExtensions.forEach((Iterator)resourceSet.getAllContents(), (Procedures.Procedure1)_function);
    }

    @Override
    public void modifyContents(Procedures.Procedure1<? super ResourceSet> modificationFunction) {
        modificationFunction.apply((Object)this.viewResourceSet);
    }

    @Override
    public CommittableView withChangeRecordingTrait() {
        this.checkNotClosed();
        return new ChangeRecordingView(this);
    }

    @Override
    public CommittableView withChangeDerivingTrait(StateBasedChangeResolutionStrategy changeResolutionStrategy) {
        this.checkNotClosed();
        return new ChangeDerivingView(this, changeResolutionStrategy);
    }

    @Override
    @Pure
    public ViewSelection getSelection() {
        return this.selection;
    }

    protected void setSelection(ViewSelection selection) {
        this.selection = selection;
    }

    @Pure
    public ViewCreatingViewType<? extends ViewSelector, HierarchicalId> getViewType() {
        return this.viewType;
    }

    protected void setViewType(ViewCreatingViewType<? extends ViewSelector, HierarchicalId> viewType) {
        this.viewType = viewType;
    }

    @Override
    @Pure
    public ChangeableViewSource getViewSource() {
        return this.viewSource;
    }

    protected void setViewSource(ChangeableViewSource viewSource) {
        this.viewSource = viewSource;
    }

    @Pure
    protected ResourceSet getViewResourceSet() {
        return this.viewResourceSet;
    }

    protected void setViewChanged(boolean viewChanged) {
        this.viewChanged = viewChanged;
    }
}

