/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.impl;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceCopier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.composite.description.CompositeContainerChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeFactory;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.CommittableView;
import tools.vitruv.framework.views.ViewSelection;
import tools.vitruv.framework.views.ViewSelector;
import tools.vitruv.framework.views.ViewType;
import tools.vitruv.framework.views.changederivation.StateBasedChangeResolutionStrategy;
import tools.vitruv.framework.views.impl.BasicView;
import tools.vitruv.framework.views.impl.ModifiableView;

public class ChangeDerivingView
implements ModifiableView,
CommittableView {
    @Delegate
    private BasicView view;
    private final StateBasedChangeResolutionStrategy changeResolutionStrategy;
    private ResourceSet originalStateViewResourceSet;
    private HashMap<Resource, Resource> originalStateResourceMapping;

    protected ChangeDerivingView(BasicView view, StateBasedChangeResolutionStrategy changeResolutionStrategy) {
        Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"view must not be null");
        boolean _isModified = view.isModified();
        boolean _not = !_isModified;
        Preconditions.checkState((boolean)_not, (Object)"view must not be modified");
        boolean _isOutdated = view.isOutdated();
        boolean _not_1 = !_isOutdated;
        Preconditions.checkState((boolean)_not_1, (Object)"view must not be outdated");
        Preconditions.checkArgument((changeResolutionStrategy != null ? 1 : 0) != 0, (Object)"change resolution strategy must not be null");
        this.view = view;
        this.changeResolutionStrategy = changeResolutionStrategy;
        this.setupReferenceState();
    }

    @Override
    public void update() {
        this.closeOriginalState();
        this.view.update();
        this.setupReferenceState();
    }

    private void setupReferenceState() {
        ResourceSetImpl _resourceSetImpl = new ResourceSetImpl();
        this.originalStateViewResourceSet = _resourceSetImpl;
        ResourceCopier.copyViewResources((Iterable)this.view.getViewResourceSet().getResources(), (ResourceSet)this.originalStateViewResourceSet);
        HashMap _hashMap = new HashMap();
        this.originalStateResourceMapping = _hashMap;
        Consumer<Resource> _function = resource -> {
            Functions.Function1 _function_1 = it -> {
                URI _uRI_1;
                URI _uRI = it.getURI();
                return _uRI == (_uRI_1 = resource.getURI());
            };
            this.originalStateResourceMapping.put((Resource)resource, (Resource)IterableExtensions.findFirst((Iterable)this.originalStateViewResourceSet.getResources(), (Functions.Function1)_function_1));
        };
        this.view.getViewResourceSet().getResources().forEach(_function);
    }

    @Override
    public void commitChanges() {
        this.view.checkNotClosed();
        ArrayList<VitruviusChange<HierarchicalId>> changes = new ArrayList<VitruviusChange<HierarchicalId>>();
        Set<Resource> _keySet = this.originalStateResourceMapping.keySet();
        HashSet<Resource> allResources = new HashSet<Resource>(_keySet);
        allResources.addAll((Collection<Resource>)this.view.getViewResourceSet().getResources());
        Functions.Function1 _function = it -> {
            boolean _isPathmap = URIUtil.isPathmap((URI)it.getURI());
            return !_isPathmap;
        };
        Iterable _filter = IterableExtensions.filter(allResources, (Functions.Function1)_function);
        for (Resource changedResource : _filter) {
            VitruviusChange<HierarchicalId> change = this.generateChange(changedResource, this.originalStateResourceMapping.get(changedResource));
            boolean _containsConcreteChange = change.containsConcreteChange();
            if (!_containsConcreteChange) continue;
            changes.add(change);
        }
        CompositeContainerChange change = VitruviusChangeFactory.getInstance().createCompositeChange(changes);
        this.view.getViewType().commitViewChanges(this, change);
        this.view.setViewChanged(false);
    }

    @Override
    public void close() throws Exception {
        boolean _not;
        boolean _isClosed = this.isClosed();
        boolean bl = _not = !_isClosed;
        if (_not) {
            this.closeOriginalState();
        }
        this.view.close();
    }

    private VitruviusChange<HierarchicalId> generateChange(Resource newState, Resource referenceState) {
        if (referenceState == null) {
            return this.changeResolutionStrategy.getChangeSequenceForCreated(newState);
        }
        if (newState == null) {
            return this.changeResolutionStrategy.getChangeSequenceForDeleted(referenceState);
        }
        return this.changeResolutionStrategy.getChangeSequenceBetween(newState, referenceState);
    }

    private void closeOriginalState() {
        Consumer<Resource> _function = it -> it.unload();
        this.originalStateViewResourceSet.getResources().forEach(_function);
        this.originalStateViewResourceSet.getResources().clear();
    }

    @Override
    public CommittableView withChangeRecordingTrait() {
        CommittableView newView = this.view.withChangeRecordingTrait();
        this.closeOriginalState();
        return newView;
    }

    @Override
    public CommittableView withChangeDerivingTrait(StateBasedChangeResolutionStrategy changeResolutionStrategy) {
        CommittableView newView = this.view.withChangeDerivingTrait(changeResolutionStrategy);
        this.closeOriginalState();
        return newView;
    }

    @Override
    public Collection<EObject> getRootObjects() {
        return this.view.getRootObjects();
    }

    @Override
    public <T> Collection<T> getRootObjects(Class<T> arg0) {
        return this.view.getRootObjects(arg0);
    }

    @Override
    public ViewSelection getSelection() {
        return this.view.getSelection();
    }

    @Override
    public ChangeableViewSource getViewSource() {
        return this.view.getViewSource();
    }

    @Override
    public ViewType<? extends ViewSelector> getViewType() {
        return this.view.getViewType();
    }

    @Override
    public boolean isClosed() {
        return this.view.isClosed();
    }

    @Override
    public boolean isModified() {
        return this.view.isModified();
    }

    @Override
    public boolean isOutdated() {
        return this.view.isOutdated();
    }

    @Override
    public void modifyContents(Procedures.Procedure1<? super ResourceSet> modificationFunction) {
        this.view.modifyContents(modificationFunction);
    }

    @Override
    public void moveRoot(EObject arg0, URI arg1) {
        this.view.moveRoot(arg0, arg1);
    }

    @Override
    public void registerRoot(EObject arg0, URI arg1) {
        this.view.registerRoot(arg0, arg1);
    }

    @Override
    public CommittableView withChangeDerivingTrait() {
        return this.view.withChangeDerivingTrait();
    }
}

