/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.EChange;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.change.composite.recording.ChangeRecorder;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.CommittableView;
import tools.vitruv.framework.views.ViewSelection;
import tools.vitruv.framework.views.ViewSelector;
import tools.vitruv.framework.views.ViewType;
import tools.vitruv.framework.views.changederivation.StateBasedChangeResolutionStrategy;
import tools.vitruv.framework.views.impl.BasicView;
import tools.vitruv.framework.views.impl.ModifiableView;

public class ChangeRecordingView
implements ModifiableView,
CommittableView {
    @Delegate
    private BasicView view;
    private ChangeRecorder changeRecorder;

    protected ChangeRecordingView(BasicView view) {
        Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"view must not be null");
        boolean _isModified = view.isModified();
        boolean _not = !_isModified;
        Preconditions.checkState((boolean)_not, (Object)"view must not be modified");
        this.view = view;
        this.setupChangeRecorder();
    }

    @Override
    public void update() {
        this.endRecordingAndClose(this.changeRecorder);
        this.view.update();
        this.setupChangeRecorder();
    }

    private List<EChange<EObject>> setupChangeRecorder() {
        ChangeRecorder _changeRecorder;
        List _xblockexpression = null;
        ResourceSet _viewResourceSet = this.view.getViewResourceSet();
        this.changeRecorder = _changeRecorder = new ChangeRecorder(_viewResourceSet);
        this.changeRecorder.addToRecording((Notifier)this.view.getViewResourceSet());
        _xblockexpression = this.changeRecorder.beginRecording();
        return _xblockexpression;
    }

    @Override
    public void commitChanges() {
        this.view.checkNotClosed();
        TransactionalChange recordedChange = this.changeRecorder.endRecording();
        VitruviusChangeResolver changeResolver = VitruviusChangeResolverFactory.forHierarchicalIds((ResourceSet)this.view.getViewResourceSet());
        VitruviusChange unresolvedChanges = changeResolver.assignIds((VitruviusChange)recordedChange);
        this.view.getViewType().commitViewChanges(this, unresolvedChanges);
        this.view.setViewChanged(false);
        this.changeRecorder.beginRecording();
    }

    @Override
    public void close() throws Exception {
        boolean _not;
        boolean _isClosed = this.isClosed();
        boolean bl = _not = !_isClosed;
        if (_not) {
            this.changeRecorder.close();
        }
        this.view.close();
    }

    private void endRecordingAndClose(ChangeRecorder recorder) {
        boolean _isRecording = recorder.isRecording();
        if (_isRecording) {
            recorder.endRecording();
        }
        recorder.close();
    }

    @Override
    public CommittableView withChangeRecordingTrait() {
        CommittableView newView = this.view.withChangeRecordingTrait();
        this.changeRecorder.close();
        return newView;
    }

    @Override
    public CommittableView withChangeDerivingTrait(StateBasedChangeResolutionStrategy changeResolutionStrategy) {
        CommittableView newView = this.view.withChangeDerivingTrait(changeResolutionStrategy);
        this.changeRecorder.close();
        return newView;
    }

    @Override
    public Collection<EObject> getRootObjects() {
        return this.view.getRootObjects();
    }

    @Override
    public <T> Collection<T> getRootObjects(Class<T> arg0) {
        return this.view.getRootObjects(arg0);
    }

    @Override
    public ViewSelection getSelection() {
        return this.view.getSelection();
    }

    @Override
    public ChangeableViewSource getViewSource() {
        return this.view.getViewSource();
    }

    @Override
    public ViewType<? extends ViewSelector> getViewType() {
        return this.view.getViewType();
    }

    @Override
    public boolean isClosed() {
        return this.view.isClosed();
    }

    @Override
    public boolean isModified() {
        return this.view.isModified();
    }

    @Override
    public boolean isOutdated() {
        return this.view.isOutdated();
    }

    @Override
    public void modifyContents(Procedures.Procedure1<? super ResourceSet> modificationFunction) {
        this.view.modifyContents(modificationFunction);
    }

    @Override
    public void moveRoot(EObject arg0, URI arg1) {
        this.view.moveRoot(arg0, arg1);
    }

    @Override
    public void registerRoot(EObject arg0, URI arg1) {
        this.view.registerRoot(arg0, arg1);
    }

    @Override
    public CommittableView withChangeDerivingTrait() {
        return this.view.withChangeDerivingTrait();
    }
}

