/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.impl;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceCopier;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.xbase.lib.Procedures;
import tools.vitruv.change.atomic.hid.HierarchicalId;
import tools.vitruv.change.atomic.uuid.UuidResolver;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.ViewSelection;
import tools.vitruv.framework.views.impl.AbstractViewType;
import tools.vitruv.framework.views.impl.BasicView;
import tools.vitruv.framework.views.impl.ModifiableView;
import tools.vitruv.framework.views.selectors.DirectViewElementSelector;

public class IdentityMappingViewType
extends AbstractViewType<DirectViewElementSelector<HierarchicalId>, HierarchicalId> {
    public IdentityMappingViewType(String name) {
        super(name);
    }

    @Override
    public DirectViewElementSelector<HierarchicalId> createSelector(ChangeableViewSource viewSource) {
        return new DirectViewElementSelector<HierarchicalId>(this, viewSource, viewSource.getViewSourceModels().stream().map(resource -> {
            if (!resource.getContents().isEmpty() && ResourceCopier.requiresFullCopy((Resource)resource)) {
                return Stream.of((EObject)resource.getContents().get(0));
            }
            return resource.getContents().stream();
        }).flatMap(Function.identity()).filter(Objects::nonNull).toList());
    }

    @Override
    public ModifiableView createView(DirectViewElementSelector<HierarchicalId> selector) {
        Preconditions.checkArgument((selector.getViewType() == this ? 1 : 0) != 0, (Object)"cannot create view with selector for different view type");
        return new BasicView(selector.getViewType(), selector.getViewSource(), selector.getSelection());
    }

    @Override
    public void updateView(ModifiableView view) {
        view.modifyContents((Procedures.Procedure1<? super ResourceSet>)((Procedures.Procedure1)viewResourceSet -> {
            viewResourceSet.getResources().forEach(Resource::unload);
            viewResourceSet.getResources().clear();
            this.createViewResources(view, (ResourceSet)viewResourceSet);
        }));
    }

    @Override
    public void commitViewChanges(ModifiableView view, VitruviusChange<HierarchicalId> viewChange) {
        ResourceSet viewSourceCopyResourceSet = ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl());
        VitruviusChangeResolver idChangeResolver = VitruviusChangeResolverFactory.forHierarchicalIds((ResourceSet)viewSourceCopyResourceSet);
        UuidResolver viewSourceCopyUuidResolver = UuidResolver.create((ResourceSet)viewSourceCopyResourceSet);
        VitruviusChangeResolver uuidChangeResolver = VitruviusChangeResolverFactory.forUuids((UuidResolver)viewSourceCopyUuidResolver);
        Map<Resource, Resource> mapping = this.createViewResources(view, viewSourceCopyResourceSet);
        view.getViewSource().getUuidResolver().resolveResources(mapping, viewSourceCopyUuidResolver);
        VitruviusChange resolvedChange = idChangeResolver.resolveAndApply(viewChange);
        VitruviusChange unresolvedChanges = uuidChangeResolver.assignIds(resolvedChange);
        view.getViewSource().propagateChange(unresolvedChanges);
    }

    private Map<Resource, Resource> createViewResources(ModifiableView view, ResourceSet viewResourceSet) {
        Collection<Resource> viewSources = view.getViewSource().getViewSourceModels();
        ViewSelection selection = view.getSelection();
        List<Resource> resourcesWithSelectedElements = viewSources.stream().filter(resource -> resource.getContents().stream().anyMatch(selection::isViewObjectSelected)).toList();
        return ResourceCopier.copyViewSourceResources(resourcesWithSelectedElements, (ResourceSet)viewResourceSet, selection::isViewObjectSelected);
    }
}

