/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.selection;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import tools.vitruv.framework.views.ModifiableViewSelection;

public abstract class AbstractViewSelection
implements ModifiableViewSelection {
    final Map<EObject, Boolean> elementsSelection = new HashMap<EObject, Boolean>();

    protected AbstractViewSelection(Collection<EObject> selectableElements) {
        selectableElements.forEach(object -> this.elementsSelection.put((EObject)Preconditions.checkNotNull((Object)object, (Object)"element to select must not be null"), false));
    }

    protected AbstractViewSelection(ModifiableViewSelection sourceViewSelection) {
        this(sourceViewSelection.getSelectableElements());
        for (EObject selectableElement : sourceViewSelection.getSelectableElements()) {
            this.setSelected(selectableElement, sourceViewSelection.isSelected(selectableElement));
        }
    }

    private void checkIsSelectable(EObject eObject) {
        Preconditions.checkState((boolean)this.isSelectable(eObject), (String)"given object %s must be contained in the selector elements", (Object)eObject);
    }

    @Override
    public boolean isSelected(EObject eObject) {
        return this.elementsSelection.getOrDefault(eObject, false);
    }

    @Override
    public boolean isSelectable(EObject eObject) {
        return this.elementsSelection.keySet().contains(eObject);
    }

    @Override
    public Collection<EObject> getSelectableElements() {
        return Collections.unmodifiableSet(this.elementsSelection.keySet());
    }

    @Override
    public void setSelected(EObject eObject, boolean selected) {
        this.checkIsSelectable(eObject);
        this.elementsSelection.put(eObject, selected);
    }
}

