/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.views.selectors;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Pure;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.ModifiableViewSelection;
import tools.vitruv.framework.views.View;
import tools.vitruv.framework.views.ViewSelection;
import tools.vitruv.framework.views.ViewSelector;
import tools.vitruv.framework.views.impl.ViewCreatingViewType;
import tools.vitruv.framework.views.selection.ElementViewSelection;

public class DirectViewElementSelector<Id>
implements ViewSelector {
    @Delegate
    private final ModifiableViewSelection viewSelection;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final ChangeableViewSource viewSource;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final ViewCreatingViewType<DirectViewElementSelector<Id>, Id> viewType;

    public DirectViewElementSelector(ViewCreatingViewType<DirectViewElementSelector<Id>, Id> viewType, ChangeableViewSource viewSource, Collection<EObject> selectableElements) {
        Preconditions.checkArgument((selectableElements != null ? 1 : 0) != 0, (Object)"selectable elements must not be null");
        Preconditions.checkArgument((viewType != null ? 1 : 0) != 0, (Object)"view type must not be null");
        Preconditions.checkArgument((viewSource != null ? 1 : 0) != 0, (Object)"view source must not be null");
        this.viewType = viewType;
        this.viewSource = viewSource;
        ElementViewSelection _elementViewSelection = new ElementViewSelection(selectableElements);
        this.viewSelection = _elementViewSelection;
    }

    @Override
    public View createView() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"the current selection is invalid, thus a view cannot be created");
        return this.viewType.createView(this);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ViewSelection getSelection() {
        return new ElementViewSelection(this.viewSelection);
    }

    @Override
    public Collection<EObject> getSelectableElements() {
        return this.viewSelection.getSelectableElements();
    }

    @Override
    public boolean isSelectable(EObject arg0) {
        return this.viewSelection.isSelectable(arg0);
    }

    @Override
    public boolean isSelected(EObject arg0) {
        return this.viewSelection.isSelected(arg0);
    }

    @Override
    public boolean isViewObjectSelected(EObject arg0) {
        return this.viewSelection.isViewObjectSelected(arg0);
    }

    @Override
    public void setSelected(EObject arg0, boolean arg1) {
        this.viewSelection.setSelected(arg0, arg1);
    }

    @Pure
    public ChangeableViewSource getViewSource() {
        return this.viewSource;
    }

    @Pure
    public ViewCreatingViewType<DirectViewElementSelector<Id>, Id> getViewType() {
        return this.viewType;
    }
}

