/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import tools.vitruv.change.composite.MetamodelDescriptor;
import tools.vitruv.change.interaction.InteractionResultProvider;
import tools.vitruv.change.interaction.InternalUserInteractor;
import tools.vitruv.change.interaction.UserInteractionFactory;
import tools.vitruv.change.propagation.ChangePropagationSpecification;
import tools.vitruv.change.propagation.ChangePropagationSpecificationProvider;
import tools.vitruv.change.propagation.ChangePropagationSpecificationRepository;
import tools.vitruv.change.utils.ProjectMarker;
import tools.vitruv.framework.views.ViewType;
import tools.vitruv.framework.views.ViewTypeRepository;
import tools.vitruv.framework.vsum.helper.VsumFileSystemLayout;
import tools.vitruv.framework.vsum.internal.InternalVirtualModel;
import tools.vitruv.framework.vsum.internal.VirtualModelImpl;

public class VirtualModelBuilder {
    private final Set<ViewType<?>> viewTypes = new HashSet();
    private final Set<ChangePropagationSpecification> changePropagationSpecifications = new HashSet<ChangePropagationSpecification>();
    private Path storageFolder;
    private InternalUserInteractor userInteractor;

    public VirtualModelBuilder withStorageFolder(File folder) {
        return this.withStorageFolder(folder.toPath());
    }

    public VirtualModelBuilder withStorageFolder(Path folder) {
        Preconditions.checkState((this.storageFolder == null || Objects.equals(this.storageFolder, folder) ? 1 : 0) != 0, (String)"There is already another storage folder set: %s", (Object)this.storageFolder);
        this.storageFolder = folder;
        return this;
    }

    public VirtualModelBuilder withUserInteractorForResultProvider(InteractionResultProvider resultProvider) {
        return this.withUserInteractor(UserInteractionFactory.instance.createUserInteractor(resultProvider));
    }

    public VirtualModelBuilder withUserInteractor(InternalUserInteractor userInteractor) {
        Preconditions.checkState((this.userInteractor == null || Objects.equals(this.userInteractor, userInteractor) ? 1 : 0) != 0, (String)"There is already another user interactor set: %s", (Object)this.userInteractor);
        this.userInteractor = userInteractor;
        return this;
    }

    public VirtualModelBuilder withViewType(ViewType<?> viewType) {
        this.viewTypes.add(viewType);
        return this;
    }

    public VirtualModelBuilder withViewTypes(Collection<ViewType<?>> viewTypes) {
        for (ViewType<?> viewType : viewTypes) {
            this.withViewType(viewType);
        }
        return this;
    }

    public VirtualModelBuilder withChangePropagationSpecifications(ChangePropagationSpecification ... changePropagationSpecifications) {
        for (ChangePropagationSpecification spec : changePropagationSpecifications) {
            this.withChangePropagationSpecification(spec);
        }
        return this;
    }

    public VirtualModelBuilder withChangePropagationSpecifications(Iterable<ChangePropagationSpecification> changePropagationSpecifications) {
        for (ChangePropagationSpecification spec : changePropagationSpecifications) {
            this.withChangePropagationSpecification(spec);
        }
        return this;
    }

    public VirtualModelBuilder withChangePropagationSpecification(ChangePropagationSpecification changePropagationSpecification) {
        boolean _contains = this.changePropagationSpecifications.contains(changePropagationSpecification);
        if (_contains) {
            return this;
        }
        for (ChangePropagationSpecification existingPropagationSpecification : this.changePropagationSpecifications) {
            boolean _equals = Objects.equals(existingPropagationSpecification, changePropagationSpecification);
            if (_equals) {
                return this;
            }
            if (!existingPropagationSpecification.getSourceMetamodelDescriptor().equals((Object)changePropagationSpecification.getSourceMetamodelDescriptor()) || !existingPropagationSpecification.getTargetMetamodelDescriptor().equals((Object)changePropagationSpecification.getTargetMetamodelDescriptor())) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("This virtual model configuration already contains the change propagation specification ");
            _builder.append((Object)existingPropagationSpecification);
            _builder.append(" between ");
            MetamodelDescriptor _sourceMetamodelDescriptor = existingPropagationSpecification.getSourceMetamodelDescriptor();
            _builder.append((Object)_sourceMetamodelDescriptor);
            _builder.append(" and ");
            MetamodelDescriptor _targetMetamodelDescriptor = existingPropagationSpecification.getTargetMetamodelDescriptor();
            _builder.append((Object)_targetMetamodelDescriptor);
            _builder.append("!");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.changePropagationSpecifications.add(changePropagationSpecification);
        return this;
    }

    public InternalVirtualModel buildAndInitialize() {
        try {
            Preconditions.checkState((this.storageFolder != null ? 1 : 0) != 0, (Object)"No storage folder was configured!");
            Preconditions.checkState((this.userInteractor != null ? 1 : 0) != 0, (Object)"No user interactor was configured!");
            ViewTypeRepository viewTypeRepository = new ViewTypeRepository();
            Consumer<ViewType> _function = it -> viewTypeRepository.register(it);
            this.viewTypes.forEach(_function);
            ChangePropagationSpecificationRepository changeSpecificationRepository = new ChangePropagationSpecificationRepository(this.changePropagationSpecifications);
            VsumFileSystemLayout fileSystemLayout = new VsumFileSystemLayout(this.storageFolder);
            fileSystemLayout.prepare();
            VirtualModelImpl vsum = new VirtualModelImpl(fileSystemLayout, this.userInteractor, viewTypeRepository, (ChangePropagationSpecificationProvider)changeSpecificationRepository);
            vsum.loadExistingModels();
            try {
                ProjectMarker.getProjectRootFolder((Path)this.storageFolder);
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalStateException) {
                    ProjectMarker.markAsProjectRootFolder((Path)this.storageFolder);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return vsum;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

