/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum.helper;

import com.google.common.base.Preconditions;
import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.common.util.URIUtil;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class VsumFileSystemLayout {
    private static final String CORRESPONDENCES_FILE = "correspondences.correspondence";
    private static final String UUIDS_FILE = "uuid.uuid";
    private static final String MODELS_FILE = "models.models";
    private static final String VSUM_FOLDER_NAME = "vsum";
    private static final String CONSISTENCY_METADATA_FOLDER_NAME = "consistencymetadata";
    private final Path vsumProjectFolder;
    private boolean prepared = false;

    public VsumFileSystemLayout(Path vsumProjectFolder) {
        this.vsumProjectFolder = vsumProjectFolder;
    }

    public void prepare() throws IOException {
        Files.createDirectories(this.getVsumFolder(), new FileAttribute[0]);
        Files.createDirectories(this.getConsistencyMetadataFolder(), new FileAttribute[0]);
        this.prepared = true;
    }

    private Path getMetadataFilePath(String ... metadataKey) {
        Preconditions.checkArgument((metadataKey != null || metadataKey.length > 0 ? 1 : 0) != 0, (Object)"The key must have at least one part!");
        int _length = metadataKey.length;
        int _minus = _length - 1;
        Preconditions.checkArgument((boolean)metadataKey[_minus].contains("."), (Object)"metadataKey is missing a file extension!");
        Functions.Function2 _function = (last, keyPart) -> {
            Path _xblockexpression = null;
            Preconditions.checkArgument((keyPart != null ? 1 : 0) != 0, (Object)"A key part must not be null!");
            String _switchResult = null;
            if (keyPart != null) {
                switch (keyPart) {
                    case ".": {
                        _switchResult = "_.";
                        break;
                    }
                    case "..": {
                        _switchResult = "_._.";
                        break;
                    }
                    case "": {
                        _switchResult = "_";
                        break;
                    }
                    default: {
                        _switchResult = keyPart.replaceAll("_", "__");
                        break;
                    }
                }
            } else {
                _switchResult = keyPart.replaceAll("_", "__");
            }
            String preparedKeyPart = _switchResult;
            _xblockexpression = last.resolve(URLEncoder.encode(preparedKeyPart, StandardCharsets.UTF_8));
            return _xblockexpression;
        };
        return (Path)IterableExtensions.fold((Iterable)((Iterable)Conversions.doWrapArray((Object)metadataKey)), (Object)Path.of("", new String[0]), (Functions.Function2)_function);
    }

    public URI getConsistencyMetadataModelURI(String ... metadataKey) {
        this.checkPrepared();
        Path metadataPath = this.getConsistencyMetadataFolder().resolve(this.getMetadataFilePath(metadataKey));
        return URIUtil.createFileURI((File)metadataPath.toFile());
    }

    public URI getCorrespondencesURI() {
        this.checkPrepared();
        return URIUtil.createFileURI((File)this.getVsumFolder().resolve(CORRESPONDENCES_FILE).toFile());
    }

    public URI getUuidsURI() {
        this.checkPrepared();
        return URIUtil.createFileURI((File)this.getVsumFolder().resolve(UUIDS_FILE).toFile());
    }

    public Path getModelsNamesFilesPath() {
        this.checkPrepared();
        return this.getVsumFolder().resolve(MODELS_FILE);
    }

    public Path getVsumProjectFolder() {
        return this.vsumProjectFolder;
    }

    private Path getVsumFolder() {
        return this.vsumProjectFolder.resolve(VSUM_FOLDER_NAME);
    }

    private Path getConsistencyMetadataFolder() {
        return this.vsumProjectFolder.resolve(CONSISTENCY_METADATA_FOLDER_NAME);
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        _builder.append((Object)this.vsumProjectFolder);
        return _builder.toString();
    }

    private void checkPrepared() {
        Preconditions.checkState((boolean)this.prepared, (Object)"The file system layout has not been loaded yet!");
    }
}

