/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class ModelInstance {
    private static final Logger LOGGER = LogManager.getLogger(ModelInstance.class);
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Resource resource;

    public ModelInstance(Resource resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"cannot create a model instance for a null resource");
        this.resource = resource;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Create model instance for resource with URI: ");
        URI _uRI = this.getURI();
        _builder.append((Object)_uRI);
        LOGGER.debug((CharSequence)_builder);
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    public void addRoot(EObject root) {
        EList _contents = this.resource.getContents();
        _contents.add((Object)root);
        this.resource.setModified(true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add root to resource: ");
        _builder.append((Object)this.resource);
        LOGGER.debug((CharSequence)_builder);
    }

    public void markModified() {
        this.resource.setModified(true);
    }

    public boolean isEmpty() {
        return this.resource.getContents().isEmpty();
    }

    public void save() {
        boolean _not;
        boolean _isModified = this.resource.isModified();
        boolean bl = _not = !_isModified;
        if (_not) {
            return;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Save resource: ");
        _builder.append((Object)this.resource);
        LOGGER.debug((CharSequence)_builder);
        try {
            this.resource.save(null);
            this.resource.setModified(false);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Model could not be saved: ");
                URI _uRI = this.getURI();
                _builder_1.append((Object)_uRI);
                LOGGER.error((CharSequence)_builder_1, (Throwable)e);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Could not save URI ");
                URI _uRI_1 = this.getURI();
                _builder_2.append((Object)_uRI_1);
                throw new IllegalStateException(_builder_2.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void delete() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Delete resource: ");
        _builder.append((Object)this.resource);
        LOGGER.debug((CharSequence)_builder);
        try {
            this.resource.delete(null);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Deletion of resource ");
                _builder_1.append((Object)this.resource);
                _builder_1.append(" did not work.");
                LOGGER.error((CharSequence)_builder_1, (Throwable)e);
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Could not delete URI ");
                URI _uRI = this.getURI();
                _builder_2.append((Object)_uRI);
                throw new IllegalStateException(_builder_2.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Pure
    public Resource getResource() {
        return this.resource;
    }
}

