/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum.internal;

import edu.kit.ipd.sdq.commons.util.org.eclipse.emf.ecore.resource.ResourceSetUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;
import tools.vitruv.change.composite.description.TransactionalChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.description.VitruviusChangeResolver;
import tools.vitruv.change.composite.description.VitruviusChangeResolverFactory;
import tools.vitruv.change.composite.recording.ChangeRecorder;
import tools.vitruv.change.correspondence.Correspondence;
import tools.vitruv.change.correspondence.model.CorrespondenceModel;
import tools.vitruv.change.correspondence.model.CorrespondenceModelFactory;
import tools.vitruv.change.correspondence.model.PersistableCorrespondenceModel;
import tools.vitruv.change.correspondence.view.CorrespondenceModelViewFactory;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.change.propagation.impl.ResourceRegistrationAdapter;
import tools.vitruv.framework.vsum.helper.VsumFileSystemLayout;
import tools.vitruv.framework.vsum.internal.ModelInstance;
import tools.vitruv.framework.vsum.internal.ModelRepository;

class ResourceRepositoryImpl
implements ModelRepository {
    private static final Logger LOGGER = LogManager.getLogger(ResourceRepositoryImpl.class);
    private final ResourceSet modelsResourceSet = ResourceSetUtil.withGlobalFactories((ResourceSet)new ResourceSetImpl());
    private final Map<URI, ModelInstance> modelInstances = new HashMap<URI, ModelInstance>();
    private final PersistableCorrespondenceModel correspondenceModel;
    private UuidResolver uuidResolver = UuidResolver.create((ResourceSet)this.modelsResourceSet);
    private final ChangeRecorder changeRecorder = new ChangeRecorder(this.modelsResourceSet);
    private final VitruviusChangeResolver<Uuid> changeResolver = VitruviusChangeResolverFactory.forUuids((UuidResolver)this.uuidResolver);
    private final VsumFileSystemLayout fileSystemLayout;
    private boolean isRecording = false;
    private boolean isLoading = false;

    ResourceRepositoryImpl(VsumFileSystemLayout fileSystemLayout) {
        this.fileSystemLayout = fileSystemLayout;
        this.correspondenceModel = CorrespondenceModelFactory.createPersistableCorrespondenceModel((URI)fileSystemLayout.getCorrespondencesURI());
        this.modelsResourceSet.eAdapters().add((Object)new ResourceRegistrationAdapter(resource -> this.getCreateOrLoadModelUnlessLoading(resource.getURI())));
    }

    @Override
    public void loadExistingModels() {
        this.isLoading = true;
        try {
            this.readModelsFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.correspondenceModel.loadSerializedCorrespondences(this.modelsResourceSet);
        this.isLoading = false;
    }

    private void writeModelsFile() throws IOException {
        Files.write(this.fileSystemLayout.getModelsNamesFilesPath(), this.modelsResourceSet.getResources().stream().map(Resource::getURI).map(Object::toString).toList(), new OpenOption[0]);
    }

    private void readModelsFile() throws IOException {
        List<URI> modelUris;
        try {
            modelUris = Files.readAllLines(this.fileSystemLayout.getModelsNamesFilesPath()).stream().map(URI::createURI).toList();
        }
        catch (NoSuchFileException e) {
            return;
        }
        modelUris.forEach(uri -> ResourceSetUtil.loadOrCreateResource((ResourceSet)this.modelsResourceSet, (URI)uri));
        this.uuidResolver.loadFromUri(this.fileSystemLayout.getUuidsURI());
        modelUris.forEach(this::createOrLoadModel);
    }

    public EditableCorrespondenceModelView<Correspondence> getCorrespondenceModel() {
        return CorrespondenceModelViewFactory.createEditableCorrespondenceModelView((CorrespondenceModel)this.correspondenceModel);
    }

    @Override
    public ModelInstance getModel(URI modelUri) {
        return this.modelInstances.get(modelUri);
    }

    public UuidResolver getUuidResolver() {
        return this.uuidResolver;
    }

    private ModelInstance getCreateOrLoadModelUnlessLoading(URI modelUri) {
        if (this.isLoading) {
            return null;
        }
        return this.getCreateOrLoadModel(modelUri);
    }

    private ModelInstance getCreateOrLoadModel(URI modelUri) {
        ModelInstance instance = this.getModel(modelUri);
        if (instance != null) {
            return instance;
        }
        return this.createOrLoadModel(modelUri);
    }

    private ModelInstance createOrLoadModel(URI modelUri) {
        Resource resource = modelUri.isFile() || modelUri.isPlatform() ? ResourceSetUtil.getOrCreateResource((ResourceSet)this.modelsResourceSet, (URI)modelUri) : ResourceSetUtil.loadOrCreateResource((ResourceSet)this.modelsResourceSet, (URI)modelUri);
        ModelInstance modelInstance = new ModelInstance(resource);
        this.modelInstances.put(modelUri, modelInstance);
        this.registerRecorder(modelInstance);
        return modelInstance;
    }

    private void registerRecorder(ModelInstance modelInstance) {
        if (modelInstance.getURI().isFile() || modelInstance.getURI().isPlatform()) {
            this.changeRecorder.addToRecording((Notifier)modelInstance.getResource());
            if (this.isRecording && !this.changeRecorder.isRecording()) {
                this.changeRecorder.beginRecording();
            }
        }
    }

    public void persistAsRoot(EObject rootObject, URI uri) {
        this.getCreateOrLoadModel(uri).addRoot(rootObject);
    }

    @Override
    public void saveOrDeleteModels() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving all models of model repository for VSUM " + String.valueOf(this.fileSystemLayout));
        }
        Iterator<Map.Entry<URI, ModelInstance>> modelInstancesIterator = this.modelInstances.entrySet().iterator();
        while (modelInstancesIterator.hasNext()) {
            ModelInstance modelInstance = modelInstancesIterator.next().getValue();
            if (modelInstance.isEmpty()) {
                modelInstance.delete();
                modelInstancesIterator.remove();
                continue;
            }
            modelInstance.save();
        }
        this.correspondenceModel.save();
        try {
            this.writeModelsFile();
            this.uuidResolver.storeAtUri(this.fileSystemLayout.getUuidsURI());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Iterable<TransactionalChange<EObject>> recordChanges(Runnable changeApplicator) {
        this.changeRecorder.beginRecording();
        this.isRecording = true;
        LOGGER.debug("Start recording virtual model");
        changeApplicator.run();
        LOGGER.debug("End recording virtual model");
        this.isRecording = false;
        this.changeRecorder.endRecording();
        TransactionalChange change = this.changeRecorder.getChange();
        this.changeResolver.assignIds((VitruviusChange)change);
        return change.containsConcreteChange() ? List.of(change) : List.of();
    }

    public VitruviusChange<EObject> applyChange(VitruviusChange<Uuid> change) {
        return this.changeResolver.resolveAndApply(change);
    }

    public URI getMetadataModelURI(String ... metadataKey) {
        return this.fileSystemLayout.getConsistencyMetadataModelURI(metadataKey);
    }

    public Resource getModelResource(URI uri) {
        return this.getCreateOrLoadModel(uri).getResource();
    }

    @Override
    public Collection<Resource> getModelResources() {
        return this.modelsResourceSet.getResources();
    }

    public void close() {
        this.changeRecorder.close();
        this.modelsResourceSet.getResources().forEach(Resource::unload);
        this.modelsResourceSet.getResources().clear();
        this.uuidResolver = null;
    }
}

