/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum.internal;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import tools.vitruv.change.atomic.uuid.Uuid;
import tools.vitruv.change.atomic.uuid.UuidResolver;
import tools.vitruv.change.composite.description.PropagatedChange;
import tools.vitruv.change.composite.description.VitruviusChange;
import tools.vitruv.change.composite.propagation.ChangePropagationListener;
import tools.vitruv.change.correspondence.Correspondence;
import tools.vitruv.change.correspondence.view.EditableCorrespondenceModelView;
import tools.vitruv.change.interaction.InternalUserInteractor;
import tools.vitruv.change.propagation.ChangePropagationMode;
import tools.vitruv.change.propagation.ChangePropagationSpecificationProvider;
import tools.vitruv.change.propagation.ChangeRecordingModelRepository;
import tools.vitruv.change.propagation.impl.ChangePropagator;
import tools.vitruv.framework.views.ChangeableViewSource;
import tools.vitruv.framework.views.ViewSelector;
import tools.vitruv.framework.views.ViewType;
import tools.vitruv.framework.views.ViewTypeProvider;
import tools.vitruv.framework.views.ViewTypeRepository;
import tools.vitruv.framework.vsum.helper.VsumFileSystemLayout;
import tools.vitruv.framework.vsum.internal.InternalVirtualModel;
import tools.vitruv.framework.vsum.internal.ModelInstance;
import tools.vitruv.framework.vsum.internal.ModelRepository;
import tools.vitruv.framework.vsum.internal.ResourceRepositoryImpl;
import tools.vitruv.framework.vsum.internal.VirtualModelRegistry;

public class VirtualModelImpl
implements InternalVirtualModel {
    private static final Logger LOGGER = LogManager.getLogger(VirtualModelImpl.class);
    private final ModelRepository resourceRepository;
    private final ViewTypeProvider viewTypeRepository;
    private final VsumFileSystemLayout fileSystemLayout;
    private final List<ChangePropagationListener> changePropagationListeners = new LinkedList<ChangePropagationListener>();
    private final ChangePropagationSpecificationProvider changePropagationSpecificationProvider;
    private final InternalUserInteractor userInteractor;
    private ChangePropagationMode changePropagationMode = ChangePropagationMode.TRANSITIVE_CYCLIC;

    public VirtualModelImpl(VsumFileSystemLayout fileSystemLayout, InternalUserInteractor userInteractor, ViewTypeRepository viewTypeRepository, ChangePropagationSpecificationProvider changePropagationSpecificationProvider) {
        this.fileSystemLayout = fileSystemLayout;
        this.viewTypeRepository = viewTypeRepository;
        this.resourceRepository = new ResourceRepositoryImpl(fileSystemLayout);
        this.changePropagationSpecificationProvider = changePropagationSpecificationProvider;
        this.userInteractor = userInteractor;
    }

    public void loadExistingModels() {
        this.resourceRepository.loadExistingModels();
    }

    @Override
    public synchronized EditableCorrespondenceModelView<Correspondence> getCorrespondenceModel() {
        return this.resourceRepository.getCorrespondenceModel();
    }

    @Override
    public synchronized ModelInstance getModelInstance(URI modelUri) {
        return this.resourceRepository.getModel(modelUri);
    }

    public UuidResolver getUuidResolver() {
        return this.resourceRepository.getUuidResolver();
    }

    private synchronized void save() {
        this.resourceRepository.saveOrDeleteModels();
    }

    public synchronized List<PropagatedChange> propagateChange(VitruviusChange<Uuid> change) {
        Preconditions.checkNotNull(change, (Object)"change to propagate");
        Preconditions.checkArgument((boolean)change.containsConcreteChange(), (String)"This change contains no concrete change:%s%s", (Object)System.lineSeparator(), change);
        LOGGER.info("Starting change propagation");
        this.startChangePropagation(change);
        ChangePropagator changePropagator = new ChangePropagator((ChangeRecordingModelRepository)this.resourceRepository, this.changePropagationSpecificationProvider, this.userInteractor, this.changePropagationMode);
        List result = changePropagator.propagateChange(change);
        this.save();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Propagated changes: " + String.valueOf(result));
        }
        this.finishChangePropagation(change, result);
        LOGGER.info("Finished change propagation");
        return result;
    }

    private void startChangePropagation(VitruviusChange<Uuid> change) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Started synchronizing change: " + String.valueOf(change));
        }
        this.changePropagationListeners.stream().forEach(it -> it.startedChangePropagation(change));
    }

    private void finishChangePropagation(VitruviusChange<Uuid> inputChange, Iterable<PropagatedChange> generatedChanges) {
        this.changePropagationListeners.stream().forEach(it -> it.finishedChangePropagation(generatedChanges));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished synchronizing change: " + String.valueOf(inputChange));
        }
    }

    @Override
    public Path getFolder() {
        return this.fileSystemLayout.getVsumProjectFolder();
    }

    public synchronized void addChangePropagationListener(ChangePropagationListener propagationListener) {
        this.changePropagationListeners.add((ChangePropagationListener)Preconditions.checkNotNull((Object)propagationListener, (Object)"propagationListener"));
    }

    public synchronized void removeChangePropagationListener(ChangePropagationListener propagationListener) {
        this.changePropagationListeners.remove(Preconditions.checkNotNull((Object)propagationListener, (Object)"propagationListener"));
    }

    public String getName() {
        return this.getFolder().getFileName().toString();
    }

    @Override
    public void dispose() {
        try {
            this.resourceRepository.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        VirtualModelRegistry.getInstance().deregisterVirtualModel(this);
    }

    public Collection<Resource> getViewSourceModels() {
        return this.resourceRepository.getModelResources();
    }

    public Collection<ViewType<?>> getViewTypes() {
        return this.viewTypeRepository.getViewTypes();
    }

    public <S extends ViewSelector> S createSelector(ViewType<S> viewType) {
        return (S)viewType.createSelector((ChangeableViewSource)this);
    }

    @Override
    public void setChangePropagationMode(ChangePropagationMode changePropagationMode) {
        this.changePropagationMode = changePropagationMode;
    }
}

