/*
 * Decompiled with CFR 0.152.
 */
package tools.vitruv.framework.vsum.internal;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tools.vitruv.framework.vsum.internal.InternalVirtualModel;

public class VirtualModelRegistry {
    private static VirtualModelRegistry instance = new VirtualModelRegistry();
    private Map<Path, InternalVirtualModel> folderToVirtualModelMap = new ConcurrentHashMap<Path, InternalVirtualModel>();

    private VirtualModelRegistry() {
    }

    public static VirtualModelRegistry getInstance() {
        return instance;
    }

    public InternalVirtualModel getVirtualModel(Path folder) {
        return this.folderToVirtualModelMap.get(folder);
    }

    public void registerVirtualModel(InternalVirtualModel model) {
        this.folderToVirtualModelMap.put(model.getFolder(), model);
    }

    public void deregisterVirtualModel(InternalVirtualModel model) {
        this.folderToVirtualModelMap.remove(model.getFolder());
    }
}

