package com.donger.oss.aliyun.config;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Data
@Configuration
@ConfigurationProperties(prefix = "oss.aliyun")
@Primary
public class OSSConfigProperties {
    private String accessId;
    private String accessKey;
    private String host;
    private String bucket;
    /**
     * 访问域名
     */
    private String endpoint = "oss-cn-beijing.aliyuncs.com";
    /**
     * 文件夹
     */
    private String dir="";
    /**
     * 回调地址
     */
    private String callbackUrl;
    /**
     * 超时时间,默认5分钟，单位（秒）
     */
    private int expire = 300;
    /*地域*/
    private String region;
    /**
     * STS API 版本
     */
    private String stsApiVersion;
    /**
     * STS roleArn
     */
    private String roleArn = "";
    /**
     * STS roleSessionName
     * 用来标识临时凭证的名称，建议使用不同的应用程序用户来区分。
     */
    private String roleSessionName = "session-name";

    /**
     * STS Policy
     * 默认拥有最高权限
     */
    private String stsPolicy = "{\n" +
            "  \"Statement\": [\n" +
            "    {\n" +
            "      \"Action\": [\n" +
            "        \"oss:*\"\n" +
            "      ],\n" +
            "      \"Effect\": \"Allow\",\n" +
            "      \"Resource\": [\"acs:oss:*:*:*\"]\n" +
            "    }\n" +
            "  ],\n" +
            "  \"Version\": \"1\"\n" +
            "}";
    /**
     * STS durationSeconds 单位：秒
     * 默认最长时间（900~3600）
     */
    private long stsDurationSeconds = 3600;

}
