package com.donger.oss.aliyun.entity;


import lombok.Data;

@Data
public class CallbackRequest {

    /**
     * 文件上传成功后，OSS 向此 url 发送回调请求，请求方法为 POST，body 为 callbackBody 指定的内容。正常情况下，该 url 需要响应 HTTP/1.1 200 OK，body 必须为 Json 格式，响应头 Content-Length 必须为合法的值，且不超过 3 MB。
     * 支持同时配置最多 5 个 url，以分号（;）分割。OSS 会依次发送请求直到第一个返回成功为止。
     * 如果没有配置或者值为空则认为没有配置 callback。
     * 支持 HTTPS 地址。
     * 为了保证正确处理中文等情况，callbackUrl 需做 url 编码处理，比如http://example.com/中文.php?key=value&中文名称=中文值 需要编码成 http://example.com/%E4%B8%AD%E6%96%87.php?key=value&%E4%B8%AD%E6%96%87%E5%90%8D%E7%A7%B0=%E4%B8%AD%E6%96%87%E5%80%BC
     */
    private String callbackUrl;
    /**
     * 发起回调请求时 Host 头的值，只有在设置了 callbackUrl 时才有效。
     * 如果没有配置 callbckHost，则会解析 callbackUrl 中的 url 并将解析出的 host 填充到 callbackHost 中。
     */
    private String callbackHost;
    /**
     * 发起回调时请求 body 的值，例如：key=$(key)&etag=$(etag)&my_var=$(x:my_var)。
     * 支持 OSS 系统变量、自定义变量和常量，支持的系统变量如下表所示 。自定义变量的支持方式在 PutObject 和CompleteMultipart 中是通过 callback-var 来传递，在 PostObject中则是将各个变量通过表单域来传递
     */
    private String callbackBody;
    /**
     * 发起回调请求的 Content-Type，支持 application/x-www-form-urlencoded 和application/json，默认为前者。
     * callbackBodyType的取值为 application/x-www-form-urlencoded，则 callbackBody 中的变量将会被经过 url 编码的值替换掉；如果为 application/json，则会按照 json 格式替换其中的变量。
     */
    private String callbackBodyType;
}
