package com.donger.oss.aliyun.service;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.donger.oss.aliyun.config.OSSConfigProperties;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@RequiredArgsConstructor
public class AliyunOssTemplate implements InitializingBean {

   private final OSSConfigProperties ossConfigProperties;
   private final OSSClient ossClient;



    public Map getPolicyWithOutCallback(){
        long expireEndTime = System.currentTimeMillis() + ossConfigProperties.getExpire() * 1000;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem(PolicyConditions.COND_CONTENT_LENGTH_RANGE, 0, 1048576000);
        policyConds.addConditionItem(MatchMode.StartWith, PolicyConditions.COND_KEY, ossConfigProperties.getDir());

        String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String(binaryData);
        String postSignature = ossClient.calculatePostSignature(postPolicy);
        Map<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.ossConfigProperties.getAccessId());
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", ossConfigProperties.getDir());
        respMap.put("host", ossConfigProperties.getHost());
        respMap.put("expire", String.valueOf(expireEndTime / 1000));
        return respMap;
    }





    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasText(ossConfigProperties.getAccessId(), "Access ID为空");
        Assert.hasText(ossConfigProperties.getDir(), "Dir 为空");
        Assert.hasText(ossConfigProperties.getHost(), "Hsot 为空");
    }
}
