package com.donger.api.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.donger.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 部门管理
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SysDept extends BaseEntity<SysDept> {

    public static final long LEVEL_ONE_DEPT = 0L;
    private static final long serialVersionUID = 1L;
    @TableId(value = "dept_id")
    private Long deptId;

    /**
     * 上级部门ID，一级部门为0
     */
    private Long parentId;

    /**
     * 部门名称
     */
    private String name;

    /**
     * 排序
     */
    private Integer orderNum;

    /**
     * 是否删除  1：已删除  0：正常
     */
    @TableLogic
    private Integer delFlag;

    /**
     * 上级部门名称
     */
    @TableField(exist = false)
    private String parentName;

    @TableField(exist = false)
    private List<SysDept> children;

}
