package com.donger.api.sys.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.donger.api.sys.entity.SysMenu;

import java.util.List;

/**
 * <p>
 * 菜单管理 服务类
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
public interface ISysMenuService extends IService<SysMenu> {

    /**
     * 通过角色ID查询菜单
     *
     * @param roleId 角色ID
     * @return 菜单列表
     */
    List<SysMenu> findMenuByRoleId(Long roleId);

    /**
     * 查询非按钮菜单
     *
     * @return 非按钮菜单列表
     */
    List<SysMenu> queryNotButtonList();

    /**
     * 查询用户菜单
     *
     * @param currentUserId 当前用户ID
     * @return 用户菜单列表
     */
    List<SysMenu> getUserMenuList(Long currentUserId);

    /**
     * 查询子菜单
     *
     * @param menuId 父ID
     * @return 子菜单列表
     */
    List<SysMenu> queryListParentId(Long menuId);
}
