/*
 * Decompiled with CFR 0.152.
 */
package top.appx.espring;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import top.appx.espring.Utils;
import top.appx.espring.annotation.Autowired;
import top.appx.espring.annotation.Controller;
import top.appx.espring.annotation.ServerThread;
import top.appx.espring.annotation.Source;

public class InitMethod {
    private static Logger Log = Logger.getLogger((String)"espring");
    public static List<Object> controllerList = new ArrayList<Object>();
    public static Map<String, Object> sourceMap = new HashMap<String, Object>();

    public static void init() throws Exception {
        InitMethod.initSource();
        InitMethod.initController();
        InitMethod.initServerThread();
        InitMethod.autowired();
    }

    public static void initServerThread() throws IllegalAccessException, InstantiationException {
        List<Class<?>> list = Utils.getClasses("com.serverThread");
        for (Class<?> c1 : list) {
            if (!c1.isAnnotationPresent(ServerThread.class)) continue;
            ServerThread serverThread = c1.getAnnotation(ServerThread.class);
            Runnable runnable = (Runnable)c1.newInstance();
            Thread thread = new Thread(runnable);
            thread.setName(serverThread.value());
            thread.start();
            Log.debug((Object)("\u542f\u52a8\u670d\u52a1\u7ebf\u7a0b:" + serverThread.value()));
        }
    }

    public static void initController() throws Exception {
        List<Class<?>> list = Utils.getClasses("com.controller");
        for (Class<?> c1 : list) {
            if (!c1.isAnnotationPresent(Controller.class)) continue;
            controllerList.add(c1.newInstance());
        }
    }

    public static void initSource() throws Exception {
        List<Class<?>> list = Utils.getClasses("com.dao");
        list.addAll(Utils.getClasses("com.service"));
        for (Class<?> c1 : list) {
            if (!c1.isAnnotationPresent(Source.class)) continue;
            Object obj = c1.newInstance();
            if (!c1.isAnnotationPresent(Source.class)) continue;
            Source source = c1.getAnnotation(Source.class);
            String key = source.value();
            if (key.equals("")) {
                key = c1.getSimpleName();
                key = (key.charAt(0) + "").toLowerCase() + key.substring(1);
            }
            sourceMap.put(key, obj);
        }
    }

    public static void autowired() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Set<String> keySet = sourceMap.keySet();
        for (String string : keySet) {
            list.add(sourceMap.get(string));
        }
        list.addAll(controllerList);
        for (String string : list) {
            Field[] fields;
            Class<?> c1 = string.getClass();
            for (Field field : fields = c1.getDeclaredFields()) {
                Object obj1;
                field.setAccessible(true);
                if (!field.isAnnotationPresent(Autowired.class)) continue;
                Autowired autowired = field.getAnnotation(Autowired.class);
                String akey = autowired.value();
                if (akey.equals("")) {
                    akey = field.getName();
                }
                if ((obj1 = sourceMap.get(akey)) == null) {
                    throw new Exception("not found the source " + akey);
                }
                field.set(string, obj1);
            }
        }
    }
}

