package top.bluesword.util.algorithm.hash.bcrypt;

import org.mindrot.jbcrypt.BCrypt;

/**
 * 修改BCrypt实现与php中相同算法统一
 *
 * @author 李林峰
 */
public class BCryptForPHP extends BCrypt {

    private BCryptForPHP() {
    }

    public static String hashpw(String password, String salt) {
        return BCrypt.hashpw(password, salt).replaceFirst("2a", "2y");
    }

    public static boolean checkpw(String plaintext, String hashed) {
        return BCrypt.checkpw(plaintext, hashed.replaceFirst("2y", "2a"));
    }
}