package top.bluesword.util.algorithm.random;

/**
 * 随机数算法
 * @author 李林峰
 */
public class MersenneTwister {

    private int[] ints = new int[624];
    private int idx;

    public MersenneTwister(int seed) {
        msInit(seed);
    }

    public int rand() {
        if (idx == 0) msRate();
        int y = ints[idx];
        y = y ^ (y >> 11);
        y = y ^ ((y << 7) & (int) 2636928640L);
        y = y ^ ((y << 15) & (int) 4022730752L);
        y = y ^ (y >> 18);
        idx = (idx + 1) % 624;
        return y;
    }

    private void msInit(int seed) {
        int i;
        int p;
        idx = 0;
        ints[0] = seed;
        for (i = 1; i < 624; ++i) {
            p = 1812433253 * (ints[i - 1] ^ (ints[i - 1] >> 30)) + i;
            ints[i] = p;
        }
    }

    private void msRate() {
        int i;
        int y;
        for (i = 0; i < 624; ++i) {
            y = (ints[i] & 0x80000000) +
                    (ints[(i + 1) % 624] & 0x7fffffff);
            ints[i] = ints[(i + 397) % 624] ^ (y >> 1);
            if (y % 2 != 0) {
                ints[i] = ints[i] ^ (int) (2567483615L);
            }
        }
    }
}
