package top.bluesword.util.exception;

/**
 * 异常工具类
 * @author 李林峰
 */
public class ExceptionUtil {

    private ExceptionUtil(){}

    /**
     * 提取异常短信息
     * @param e 异常类
     * @param monitored 异常地点
     * @return 异常短信息
     */
    public static String getShortMassage(Exception e,String monitored){
        StringBuilder err = new StringBuilder(e.toString());
        for (StackTraceElement traceElement : e.getStackTrace()) {
            String s = traceElement.toString();
            if (s.startsWith(monitored)){
                err.append("[").append(s).append("]");
                break;
            }
        }
        return err.toString();
    }
}
