package top.bluesword.util.network;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * 获取mac 地址列表
 * @author 李林峰
 */
public class LocalMacUtil {

    private LocalMacUtil(){}

    public static List<String> getLocalMac() throws SocketException {
        List<String> mac = new ArrayList<>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            StringBuilder builder = new StringBuilder();
            NetworkInterface networkInterface = enumeration.nextElement();
            if (networkInterface == null) continue;
            byte[] bytes = networkInterface.getHardwareAddress();
            if (bytes == null) continue;
            for (int i = 0; i < bytes.length; i++) {
                if (i != 0) builder.append(":");
                int tmp = bytes[i] & 0xff;
                String str = Integer.toHexString(tmp);
                if (str.length() == 1) builder.append("0");
                builder.append(str);
            }
            mac.add(builder.toString());
        }
        return mac;
    }
}
