package top.bluesword.util.network.time;

import top.bluesword.util.exception.SwordRuntimeException;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

/**
 * 读取网络时间
 * @author 李林峰
 */
public class GetNetworkTime {

    private GetNetworkTime (){}

    /**
     * 获取指定网站的日期时间
     * @param webUrl 网站地址
     * @return 网站时间
     */
    public static Date getWebsiteDatetime(String webUrl) {
        try {
            URLConnection uc = new URL(webUrl).openConnection();
            uc.connect();
            return new Date(uc.getDate());
        } catch (IOException e) {
            throw new SwordRuntimeException("请求失败");
        }
    }
}
