/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.algorithm;

public class Trie {
    private boolean end = false;
    private Trie[] children = new Trie[26];

    public void insert(String word) {
        this.add(this, word.toCharArray(), 0);
    }

    public void add(Trie t, char[] chars, int index) {
        if (chars.length > index) {
            if (t.children[chars[index] - 97] == null) {
                t.children[chars[index] - 97] = new Trie();
            }
            if (chars.length - 1 == index) {
                t.children[chars[index] - 97].end = true;
            }
            t.add(t.children[chars[index] - 97], chars, index + 1);
        }
    }

    public boolean search(String word) {
        Trie node = this;
        for (char c : word.toCharArray()) {
            if (node.children[c - 97] == null) {
                return false;
            }
            node = node.children[c - 97];
        }
        return node.end;
    }

    public boolean startsWith(String prefix) {
        Trie node = this;
        for (char c : prefix.toCharArray()) {
            if (node.children[c - 97] == null) {
                return false;
            }
            node = node.children[c - 97];
        }
        return true;
    }
}

