/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.algorithm.random;

public class MersenneTwister {
    private int[] ints = new int[624];
    private int idx;

    public MersenneTwister(int seed) {
        this.msInit(seed);
    }

    public int rand() {
        if (this.idx == 0) {
            this.msRate();
        }
        int y = this.ints[this.idx];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >> 18;
        this.idx = (this.idx + 1) % 624;
        return y;
    }

    private void msInit(int seed) {
        this.idx = 0;
        this.ints[0] = seed;
        for (int i = 1; i < 624; ++i) {
            int p;
            this.ints[i] = p = 1812433253 * (this.ints[i - 1] ^ this.ints[i - 1] >> 30) + i;
        }
    }

    private void msRate() {
        for (int i = 0; i < 624; ++i) {
            int y = (this.ints[i] & Integer.MIN_VALUE) + (this.ints[(i + 1) % 624] & Integer.MAX_VALUE);
            this.ints[i] = this.ints[(i + 397) % 624] ^ y >> 1;
            if (y % 2 == 0) continue;
            this.ints[i] = this.ints[i] ^ 0x9908B0DF;
        }
    }
}

