/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.xposed;

import android.content.pm.ApplicationInfo;
import android.util.Log;
import de.robv.android.xposed.IXposedHookLoadPackage;
import de.robv.android.xposed.IXposedHookZygoteInit;
import de.robv.android.xposed.IXposedMod;
import de.robv.android.xposed.XposedBridge;
import de.robv.android.xposed.callbacks.XC_LoadPackage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import top.canyie.pine.xposed.ModuleClassLoader;

public final class PineXposed {
    public static final String TAG = "PineXposed";
    public static boolean disableHooks = false;
    public static boolean disableZygoteInitCallbacks = false;
    private static ExtHandler sExtHandler;
    private static final XposedBridge.CopyOnWriteSortedSet<XC_LoadPackage> sLoadedPackageCallbacks;

    public static ExtHandler getExtHandler() {
        return sExtHandler;
    }

    public static void setExtHandler(ExtHandler n) {
        sExtHandler = n;
    }

    private PineXposed() {
    }

    public static void loadModule(String module) {
        PineXposed.loadModule(new File(module));
    }

    public static void loadModule(File module) {
        PineXposed.loadModule(module, false);
    }

    public static void loadModule(File module, boolean startsSystemServer) {
        PineXposed.loadModule(module, null, startsSystemServer);
    }

    public static void loadModule(File module, String librarySearchPath, boolean startsSystemServer) {
        if (!module.exists()) {
            Log.e((String)TAG, (String)("  File " + module + " does not exist"));
            return;
        }
        ClassLoader initCl = PineXposed.class.getClassLoader();
        String modulePath = module.getAbsolutePath();
        ModuleClassLoader mcl = new ModuleClassLoader(modulePath, librarySearchPath, initCl);
        PineXposed.loadOpenedModule(modulePath, (ClassLoader)((Object)mcl), startsSystemServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadOpenedModule(String modulePath, ClassLoader mcl, boolean startsSystemServer) {
        InputStream initIs;
        if (!PineXposed.checkModule(mcl)) {
            return;
        }
        try {
            URL url;
            String filename = "assets/xposed_init";
            initIs = mcl instanceof ModuleClassLoader ? ((url = ((ModuleClassLoader)((Object)mcl)).findResource("assets/xposed_init")) != null ? url.openStream() : null) : mcl.getResourceAsStream("assets/xposed_init");
            if (initIs == null) {
                Log.e((String)TAG, (String)("  Failed to load module " + modulePath));
                Log.e((String)TAG, (String)"  assets/xposed_init not found in the module APK");
                return;
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("  Failed to load module " + modulePath));
            Log.e((String)TAG, (String)"  Cannot open assets/xposed_init in the module APK", (Throwable)e);
            return;
        }
        BufferedReader xposedInitReader = new BufferedReader(new InputStreamReader(initIs));
        try {
            String className;
            while ((className = xposedInitReader.readLine()) != null) {
                if ((className = className.trim()).isEmpty() || className.startsWith("#")) continue;
                try {
                    ExtHandler extHandler;
                    Class<?> c = mcl.loadClass(className);
                    if (!IXposedMod.class.isAssignableFrom(c)) {
                        Log.e((String)TAG, (String)("    Cannot load callback class " + className + " in module " + modulePath + " :"));
                        Log.e((String)TAG, (String)"    This class doesn't implement any sub-interface of IXposedMod, skipping it");
                        continue;
                    }
                    IXposedMod callback = (IXposedMod)c.newInstance();
                    if (callback instanceof IXposedHookZygoteInit && !disableZygoteInitCallbacks) {
                        IXposedHookZygoteInit.StartupParam param = new IXposedHookZygoteInit.StartupParam();
                        param.modulePath = modulePath;
                        param.startsSystemServer = startsSystemServer;
                        ((IXposedHookZygoteInit)callback).initZygote(param);
                    }
                    if (callback instanceof IXposedHookLoadPackage) {
                        PineXposed.hookLoadPackage((IXposedHookLoadPackage)callback);
                    }
                    if ((extHandler = sExtHandler) == null) continue;
                    extHandler.handle(callback);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)("    Failed to load class " + className + " from module " + modulePath + " :"), (Throwable)e);
                }
            }
            return;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("  Failed to load module " + modulePath));
            Log.e((String)TAG, (String)"  Cannot read assets/xposed_init in the module APK", (Throwable)e);
            return;
        }
        finally {
            PineXposed.closeQuietly(xposedInitReader);
        }
    }

    public static boolean checkModule(ClassLoader mcl) {
        boolean conflict;
        boolean fastPath = mcl instanceof ModuleClassLoader;
        try {
            Class<?> cls;
            String name = "com.android.tools.fd.runtime.BootstrapApplication";
            Class<?> clazz = cls = fastPath ? ((ModuleClassLoader)((Object)mcl)).findClass(name) : mcl.loadClass(name);
            if (cls != null) {
                Log.e((String)TAG, (String)"  Cannot load module, please disable \"Instant Run\" in Android Studio.");
                return false;
            }
        }
        catch (ClassNotFoundException name) {
            // empty catch block
        }
        if (fastPath) {
            try {
                conflict = ((ModuleClassLoader)((Object)mcl)).findClass(XposedBridge.class.getName()) != null;
            }
            catch (ClassNotFoundException ignored) {
                conflict = false;
            }
        } else {
            try {
                conflict = mcl.loadClass(XposedBridge.class.getName()) != XposedBridge.class;
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"  Cannot load module, XposedBridge is not available on the class loader", (Throwable)e);
                Log.e((String)TAG, (String)"  Make sure you have set parent of the class loader");
                return false;
            }
        }
        if (conflict) {
            Log.e((String)TAG, (String)"  Cannot load module:");
            Log.e((String)TAG, (String)"  The Xposed API classes are compiled into the module's APK.");
            Log.e((String)TAG, (String)"  This may cause strange issues and must be fixed by the module developer.");
            Log.e((String)TAG, (String)"  For details, see: http://api.xposed.info/using.html");
            return false;
        }
        return true;
    }

    public static void hookLoadPackage(IXposedHookLoadPackage callback) {
        sLoadedPackageCallbacks.add(new IXposedHookLoadPackage.Wrapper(callback));
    }

    public static void onPackageLoad(String packageName, String processName, ApplicationInfo appInfo, boolean isFirstApp, ClassLoader classLoader) {
        XC_LoadPackage.LoadPackageParam param = new XC_LoadPackage.LoadPackageParam(sLoadedPackageCallbacks);
        param.packageName = packageName;
        param.processName = processName;
        param.appInfo = appInfo;
        param.isFirstApplication = isFirstApp;
        param.classLoader = classLoader;
        XC_LoadPackage.callAll(param);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        sLoadedPackageCallbacks = new XposedBridge.CopyOnWriteSortedSet();
    }

    public static interface ExtHandler {
        public void handle(IXposedMod var1);
    }
}

