/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.captcha.graphic.autoconfigure;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import top.continew.starter.captcha.graphic.autoconfigure.GraphicCaptchaProperties;
import top.continew.starter.captcha.graphic.core.GraphicCaptchaService;

@AutoConfiguration
@EnableConfigurationProperties(value={GraphicCaptchaProperties.class})
@ConditionalOnProperty(prefix="continew-starter.captcha.graphic", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class GraphicCaptchaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraphicCaptchaAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public GraphicCaptchaService graphicCaptchaService(GraphicCaptchaProperties properties) {
        return new GraphicCaptchaService(properties);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Captcha-Graphic' completed initialization.");
    }
}

