/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.autoconfigure;

import jakarta.annotation.PostConstruct;
import jakarta.validation.Validator;
import java.util.Properties;
import org.hibernate.validator.HibernateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@AutoConfiguration
public class ValidatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ValidatorAutoConfiguration.class);

    @Bean
    public Validator validator(MessageSource messageSource) {
        try (LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();){
            factoryBean.setValidationMessageSource(messageSource);
            factoryBean.setProviderClass(HibernateValidator.class);
            Properties properties = new Properties();
            properties.setProperty("hibernate.validator.fail_fast", "true");
            factoryBean.setValidationProperties(properties);
            factoryBean.afterPropertiesSet();
            Validator validator = factoryBean.getValidator();
            return validator;
        }
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Validator' completed initialization.");
    }
}

