/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.autoconfigure.threadpool;

import cn.hutool.core.util.ArrayUtil;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import top.continew.starter.core.exception.BaseException;

@Lazy
@AutoConfiguration
@EnableAsync(proxyTargetClass=true)
@ConditionalOnProperty(prefix="spring.task.execution.extension", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AsyncAutoConfiguration
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AsyncAutoConfiguration.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public AsyncAutoConfiguration(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    public Executor getAsyncExecutor() {
        return this.threadPoolTaskExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (throwable, method, objects) -> {
            StringBuilder sb = new StringBuilder();
            sb.append("Exception message: ").append(throwable.getMessage()).append(", Method name: ").append(method.getName());
            if (ArrayUtil.isNotEmpty((Object[])objects)) {
                sb.append(", Parameter value: ").append(Arrays.toString(objects));
            }
            throw new BaseException(sb.toString());
        };
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'AsyncConfigurer' completed initialization.");
    }
}

