/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.autoconfigure.threadpool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskSchedulerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import top.continew.starter.core.autoconfigure.threadpool.ThreadPoolExtensionProperties;

@Lazy
@AutoConfiguration
@EnableConfigurationProperties(value={ThreadPoolExtensionProperties.class})
public class ThreadPoolAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolAutoConfiguration.class);
    @Value(value="${spring.task.execution.pool.core-size:#{T(java.lang.Runtime).getRuntime().availableProcessors() + 1}}")
    private int corePoolSize;
    @Value(value="${spring.task.execution.pool.max-size:#{T(java.lang.Runtime).getRuntime().availableProcessors() * 2}}")
    private int maxPoolSize;

    @Bean
    @ConditionalOnProperty(prefix="spring.task.execution.extension", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public ThreadPoolTaskExecutorCustomizer threadPoolTaskExecutorCustomizer(ThreadPoolExtensionProperties properties) {
        return executor -> {
            executor.setCorePoolSize(this.corePoolSize);
            executor.setMaxPoolSize(this.maxPoolSize);
            executor.setRejectedExecutionHandler(properties.getExecution().getRejectedPolicy().getRejectedExecutionHandler());
            log.debug("[ContiNew Starter] - Auto Configuration 'TaskExecutor' completed initialization.");
        };
    }

    @EnableScheduling
    @ConditionalOnProperty(prefix="spring.task.scheduling.extension", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public static class TaskSchedulerConfiguration {
        @Bean
        public ThreadPoolTaskSchedulerCustomizer threadPoolTaskSchedulerCustomizer(ThreadPoolExtensionProperties properties) {
            return executor -> {
                executor.setRejectedExecutionHandler(properties.getScheduling().getRejectedPolicy().getRejectedExecutionHandler());
                log.debug("[ContiNew Starter] - Auto Configuration 'TaskScheduler' completed initialization.");
            };
        }
    }
}

