/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.http.HtmlUtil;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.dreamlu.mica.ip2region.core.Ip2regionSearcher;
import net.dreamlu.mica.ip2region.core.IpInfo;

public class IpUtils {
    private IpUtils() {
    }

    public static String getIpv4Address(String ip) {
        if (IpUtils.isInnerIpv4(ip)) {
            return "\u5185\u7f51IP";
        }
        Ip2regionSearcher ip2regionSearcher = (Ip2regionSearcher)SpringUtil.getBean(Ip2regionSearcher.class);
        IpInfo ipInfo = ip2regionSearcher.memorySearch(ip);
        if (null == ipInfo) {
            return null;
        }
        LinkedHashSet regionSet = CollUtil.newLinkedHashSet((Object[])new String[]{ipInfo.getCountry(), ipInfo.getRegion(), ipInfo.getProvince(), ipInfo.getCity(), ipInfo.getIsp()});
        regionSet.removeIf(Objects::isNull);
        return String.join((CharSequence)"|", regionSet);
    }

    public static boolean isInnerIpv4(String ip) {
        return NetUtil.isInnerIP((String)("0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : HtmlUtil.cleanHtmlTag((String)ip)));
    }
}

