/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.validation;

import cn.hutool.core.text.CharSequenceUtil;
import java.util.function.BooleanSupplier;
import top.continew.starter.core.exception.BusinessException;
import top.continew.starter.core.validation.Validator;

public class CheckUtils
extends Validator {
    private static final Class<BusinessException> EXCEPTION_TYPE = BusinessException.class;

    private CheckUtils() {
    }

    public static void throwIfNotExists(Object obj, String entityName, String fieldName, Object fieldValue) {
        String message = "%s \u4e3a [%s] \u7684 %s \u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728".formatted(fieldName, fieldValue, CharSequenceUtil.replace((CharSequence)entityName, (CharSequence)"DO", (CharSequence)""));
        CheckUtils.throwIfNull(obj, message, EXCEPTION_TYPE);
    }

    public static void throwIfNull(Object obj, String template, Object ... params) {
        CheckUtils.throwIfNull(obj, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfNotNull(Object obj, String template, Object ... params) {
        CheckUtils.throwIfNotNull(obj, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfExists(Object obj, String entityName, String fieldName, Object fieldValue) {
        String message = "%s \u4e3a [%s] \u7684 %s \u8bb0\u5f55\u5df2\u5b58\u5728".formatted(fieldName, fieldValue, entityName);
        CheckUtils.throwIfNotNull(obj, message, EXCEPTION_TYPE);
    }

    public static void throwIfEmpty(Object obj, String template, Object ... params) {
        CheckUtils.throwIfEmpty(obj, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfNotEmpty(Object obj, String template, Object ... params) {
        CheckUtils.throwIfNotEmpty(obj, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfBlank(CharSequence str, String template, Object ... params) {
        CheckUtils.throwIfBlank(str, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfNotBlank(CharSequence str, String template, Object ... params) {
        CheckUtils.throwIfNotBlank(str, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfEqual(Object obj1, Object obj2, String template, Object ... params) {
        CheckUtils.throwIfEqual(obj1, obj2, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfNotEqual(Object obj1, Object obj2, String template, Object ... params) {
        CheckUtils.throwIfNotEqual(obj1, obj2, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfEqualIgnoreCase(CharSequence str1, CharSequence str2, String template, Object ... params) {
        CheckUtils.throwIfEqualIgnoreCase(str1, str2, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIfNotEqualIgnoreCase(CharSequence str1, CharSequence str2, String template, Object ... params) {
        CheckUtils.throwIfNotEqualIgnoreCase(str1, str2, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIf(boolean condition, String template, Object ... params) {
        CheckUtils.throwIf(condition, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }

    public static void throwIf(BooleanSupplier conditionSupplier, String template, Object ... params) {
        CheckUtils.throwIf(conditionSupplier, CharSequenceUtil.format((CharSequence)template, (Object[])params), EXCEPTION_TYPE);
    }
}

