/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.core.validation.constraints;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.core.validation.constraints.EnumValue;

public class EnumValueValidator
implements ConstraintValidator<EnumValue, Object> {
    private static final Logger log = LoggerFactory.getLogger(EnumValueValidator.class);
    private Class<? extends Enum> enumClass;
    private String[] enumValues;
    private String enumMethod;

    public void initialize(EnumValue enumValue) {
        this.enumClass = enumValue.value();
        this.enumValues = enumValue.enumValues();
        this.enumMethod = enumValue.method();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.enumValues.length > 0) {
            return Arrays.asList(this.enumValues).contains(Convert.toStr((Object)value));
        }
        Enum[] enumConstants = this.enumClass.getEnumConstants();
        if (enumConstants.length == 0) {
            return false;
        }
        if (CharSequenceUtil.isBlank((CharSequence)this.enumMethod)) {
            return this.findEnumValue(enumConstants, Enum::toString, Convert.toStr((Object)value));
        }
        try {
            Method method = this.enumClass.getMethod(this.enumMethod, new Class[0]);
            for (Enum enumConstant : enumConstants) {
                if (!Convert.toStr((Object)method.invoke((Object)enumConstant, new Object[0])).equals(Convert.toStr((Object)value))) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while validating the enum value, please check the @EnumValue parameter configuration.", (Throwable)e);
        }
        return false;
    }

    private boolean findEnumValue(Enum[] enumConstants, Function<Enum, Object> function, Object value) {
        for (Enum enumConstant : enumConstants) {
            if (!function.apply(enumConstant).equals(value)) continue;
            return true;
        }
        return false;
    }
}

