/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.core.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import top.continew.starter.core.exception.BusinessException;
import top.continew.starter.data.core.enums.DatabaseType;

public class MetaUtils {
    private MetaUtils() {
    }

    public static DatabaseType getDatabaseTypeOrDefault(DataSource dataSource, DatabaseType defaultValue) {
        DatabaseType databaseType = MetaUtils.getDatabaseType(dataSource);
        return null == databaseType ? defaultValue : databaseType;
    }

    public static DatabaseType getDatabaseType(DataSource dataSource) {
        DatabaseType databaseType;
        block8: {
            Connection conn = dataSource.getConnection();
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                databaseType = DatabaseType.get(databaseProductName);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BusinessException((Throwable)e);
                }
            }
            conn.close();
        }
        return databaseType;
    }

    public static List<Table> getTables(DataSource dataSource) {
        return MetaUtils.getTables(dataSource, null);
    }

    public static List<Table> getTables(DataSource dataSource, String tableName) {
        ArrayList<Table> arrayList;
        ArrayList<Table> tables = new ArrayList<Table>();
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String catalog = MetaUtil.getCatalog((Connection)conn);
            String schema = MetaUtil.getSchema((Connection)conn);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, Convert.toStrArray((Object)TableType.TABLE));){
                if (rs != null) {
                    while (rs.next()) {
                        String name = rs.getString("TABLE_NAME");
                        if (!CharSequenceUtil.isNotBlank((CharSequence)name)) continue;
                        Table table = Table.create((String)name);
                        table.setCatalog(catalog);
                        table.setSchema(schema);
                        table.setComment(MetaUtil.getRemarks((DatabaseMetaData)metaData, (String)catalog, (String)schema, (String)name));
                        tables.add(table);
                    }
                }
            }
            arrayList = tables;
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
        return arrayList;
    }

    public static Collection<Column> getColumns(DataSource dataSource, String tableName) {
        Table table = MetaUtil.getTableMeta((DataSource)dataSource, (String)tableName);
        return table.getColumns();
    }
}

