/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.data.mp.handler;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.EnumTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import top.continew.starter.data.mp.handler.MybatisBaseEnumTypeHandler;

public class CompositeBaseEnumTypeHandler<E extends Enum<E>>
implements TypeHandler<E> {
    private static final Map<Class<?>, Boolean> MP_ENUM_CACHE = new ConcurrentHashMap();
    private static Class<? extends TypeHandler> defaultEnumTypeHandler = EnumTypeHandler.class;
    private final TypeHandler<E> delegate;

    public CompositeBaseEnumTypeHandler(Class<E> enumClassType) {
        if (enumClassType == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.delegate = Boolean.TRUE.equals(CollectionUtils.computeIfAbsent(MP_ENUM_CACHE, enumClassType, MybatisBaseEnumTypeHandler::isMpEnums)) ? new MybatisBaseEnumTypeHandler<E>(enumClassType) : this.getInstance(enumClassType, defaultEnumTypeHandler);
    }

    public static void setDefaultEnumTypeHandler(Class<? extends TypeHandler> defaultEnumTypeHandler) {
        if (defaultEnumTypeHandler != null && !MybatisBaseEnumTypeHandler.class.isAssignableFrom(defaultEnumTypeHandler)) {
            CompositeBaseEnumTypeHandler.defaultEnumTypeHandler = defaultEnumTypeHandler;
        }
    }

    public void setParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        this.delegate.setParameter(ps, i, parameter, jdbcType);
    }

    public E getResult(ResultSet rs, String columnName) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnName));
    }

    public E getResult(ResultSet rs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(rs, columnIndex));
    }

    public E getResult(CallableStatement cs, int columnIndex) throws SQLException {
        return (E)((Enum)this.delegate.getResult(cs, columnIndex));
    }

    public <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, (Throwable)e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, (Throwable)e);
        }
    }
}

