/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.autoconfigure;

import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import top.continew.starter.extension.crud.annotation.CrudApi;
import top.continew.starter.extension.crud.aop.CrudApiAnnotationAdvisor;
import top.continew.starter.extension.crud.aop.CrudApiAnnotationInterceptor;
import top.continew.starter.extension.crud.autoconfigure.CrudProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={CrudProperties.class})
public class CrudRestControllerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CrudRestControllerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CrudApiAnnotationAdvisor crudApiAnnotationAdvisor(CrudApiAnnotationInterceptor crudApiAnnotationInterceptor) {
        return new CrudApiAnnotationAdvisor(crudApiAnnotationInterceptor, CrudApi.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public CrudApiAnnotationInterceptor crudApiAnnotationInterceptor() {
        return new CrudApiAnnotationInterceptor();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Extension-CRUD REST Controller' completed initialization.");
    }
}

