/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.controller;

import cn.hutool.core.lang.tree.Tree;
import com.feiniaojin.gracefulresponse.api.ExcludeFromGracefulResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import top.continew.starter.extension.crud.annotation.CrudApi;
import top.continew.starter.extension.crud.enums.Api;
import top.continew.starter.extension.crud.handler.CrudApiHandler;
import top.continew.starter.extension.crud.model.query.PageQuery;
import top.continew.starter.extension.crud.model.query.SortQuery;
import top.continew.starter.extension.crud.model.req.IdsReq;
import top.continew.starter.extension.crud.model.resp.BasePageResp;
import top.continew.starter.extension.crud.model.resp.IdResp;
import top.continew.starter.extension.crud.service.BaseService;
import top.continew.starter.extension.crud.validation.CrudValidationGroup;

public abstract class AbstractBaseController<S extends BaseService<L, D, Q, C>, L, D, Q, C>
implements CrudApiHandler {
    @Autowired
    protected S baseService;

    @CrudApi(value=Api.PAGE)
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u5217\u8868", description="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @ResponseBody
    @GetMapping
    public BasePageResp<L> page(@Validated Q query, @Validated PageQuery pageQuery) {
        return this.baseService.page(query, pageQuery);
    }

    @CrudApi(value=Api.LIST)
    @Operation(summary="\u67e5\u8be2\u5217\u8868", description="\u67e5\u8be2\u5217\u8868")
    @ResponseBody
    @GetMapping(value={"/list"})
    public List<L> list(@Validated Q query, @Validated SortQuery sortQuery) {
        return this.baseService.list(query, sortQuery);
    }

    @CrudApi(value=Api.TREE)
    @Operation(summary="\u67e5\u8be2\u6811\u5217\u8868", description="\u67e5\u8be2\u6811\u5217\u8868")
    @ResponseBody
    @GetMapping(value={"/tree"})
    public List<Tree<Long>> tree(@Validated Q query, @Validated SortQuery sortQuery) {
        return this.baseService.tree(query, sortQuery, false);
    }

    @CrudApi(value=Api.GET)
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5", description="\u67e5\u8be2\u8be6\u60c5")
    @Parameter(name="id", description="ID", example="1", in=ParameterIn.PATH)
    @ResponseBody
    @GetMapping(value={"/{id}"})
    public D get(@PathVariable(value="id") Long id) {
        return this.baseService.get(id);
    }

    @CrudApi(value=Api.CREATE)
    @Operation(summary="\u521b\u5efa\u6570\u636e", description="\u521b\u5efa\u6570\u636e")
    @ResponseBody
    @PostMapping
    public IdResp<Long> create(@Validated(value={CrudValidationGroup.Create.class}) @RequestBody C req) {
        return new IdResp<Long>(this.baseService.create(req));
    }

    @CrudApi(value=Api.UPDATE)
    @Operation(summary="\u4fee\u6539\u6570\u636e", description="\u4fee\u6539\u6570\u636e")
    @Parameter(name="id", description="ID", example="1", in=ParameterIn.PATH)
    @ResponseBody
    @PutMapping(value={"/{id}"})
    public void update(@Validated(value={CrudValidationGroup.Update.class}) @RequestBody C req, @PathVariable(value="id") Long id) {
        this.baseService.update(req, id);
    }

    @CrudApi(value=Api.DELETE)
    @Operation(summary="\u5220\u9664\u6570\u636e", description="\u5220\u9664\u6570\u636e")
    @ResponseBody
    @DeleteMapping
    public void delete(@Validated @RequestBody IdsReq req) {
        this.baseService.delete(req.getIds());
    }

    @CrudApi(value=Api.EXPORT)
    @ExcludeFromGracefulResponse
    @Operation(summary="\u5bfc\u51fa\u6570\u636e", description="\u5bfc\u51fa\u6570\u636e")
    @GetMapping(value={"/export"})
    public void export(@Validated Q query, @Validated SortQuery sortQuery, HttpServletResponse response) {
        this.baseService.export(query, sortQuery, response);
    }
}

