/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.crud.model.query;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import org.hibernate.validator.constraints.Range;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Sort;
import top.continew.starter.extension.crud.model.query.SortQuery;

@ParameterObject
@Schema(description="\u5206\u9875\u67e5\u8be2\u6761\u4ef6")
public class PageQuery
extends SortQuery {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PAGE = 1;
    private static final int DEFAULT_SIZE = 10;
    @Schema(description="\u9875\u7801", example="1")
    @Min(value=1L, message="\u9875\u7801\u6700\u5c0f\u503c\u4e3a {value}")
    private @Min(value=1L, message="\u9875\u7801\u6700\u5c0f\u503c\u4e3a {value}") Integer page = 1;
    @Schema(description="\u6bcf\u9875\u6761\u6570", example="10")
    @Range(min=1L, max=1000L, message="\u6bcf\u9875\u6761\u6570\uff08\u53d6\u503c\u8303\u56f4 {min}-{max}\uff09")
    private @Range(min=1L, max=1000L, message="\u6bcf\u9875\u6761\u6570\uff08\u53d6\u503c\u8303\u56f4 {min}-{max}\uff09") Integer size = 10;

    public PageQuery() {
    }

    public PageQuery(Integer page, Integer size) {
        this.page = page;
        this.size = size;
    }

    public PageQuery(Integer page, Integer size, String ... sort) {
        super(sort);
        this.page = page;
        this.size = size;
    }

    public PageQuery(String ... sort) {
        super(sort);
    }

    public PageQuery(String field, Sort.Direction direction) {
        super(field, direction);
    }

    public PageQuery(Sort sort) {
        super(sort);
    }

    public PageQuery(Integer page, Integer size, String field, Sort.Direction direction) {
        super(field, direction);
        this.page = page;
        this.size = size;
    }

    public PageQuery(Integer page, Integer size, Sort sort) {
        super(sort);
        this.page = page;
        this.size = size;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }
}

