/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.datapermission.autoconfigure;

import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import top.continew.starter.extension.datapermission.autoconfigure.DataPermissionProperties;
import top.continew.starter.extension.datapermission.filter.DataPermissionUserContextProvider;
import top.continew.starter.extension.datapermission.handler.DefaultDataPermissionHandler;

@AutoConfiguration
@EnableConfigurationProperties(value={DataPermissionProperties.class})
@ConditionalOnProperty(prefix="continew-starter.data-permission", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DataPermissionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataPermissionAutoConfiguration.class);

    private DataPermissionAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public DataPermissionInterceptor dataPermissionInterceptor(DataPermissionHandler dataPermissionHandler) {
        return new DataPermissionInterceptor(dataPermissionHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataPermissionHandler dataPermissionHandler(DataPermissionUserContextProvider dataPermissionUserContextProvider) {
        return new DefaultDataPermissionHandler(dataPermissionUserContextProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataPermissionUserContextProvider dataPermissionUserContextProvider() {
        if (log.isErrorEnabled()) {
            log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(DataPermissionUserContextProvider.class));
        }
        throw new NoSuchBeanDefinitionException(DataPermissionUserContextProvider.class);
    }

    static {
        log.debug("[ContiNew Starter] - Auto Configuration 'DataPermission' completed initialization.");
    }
}

