/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.datapermission.handler;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.data.core.enums.DatabaseType;
import top.continew.starter.data.core.util.MetaUtils;
import top.continew.starter.extension.datapermission.annotation.DataPermission;
import top.continew.starter.extension.datapermission.enums.DataScope;
import top.continew.starter.extension.datapermission.filter.DataPermissionUserContextProvider;
import top.continew.starter.extension.datapermission.model.RoleContext;
import top.continew.starter.extension.datapermission.model.UserContext;

public class DefaultDataPermissionHandler
implements DataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataPermissionHandler.class);
    private final DataPermissionUserContextProvider dataPermissionUserContextProvider;
    private static final DataSource dataSource = (DataSource)SpringUtil.getBean(DataSource.class);

    public DefaultDataPermissionHandler(DataPermissionUserContextProvider dataPermissionUserContextProvider) {
        this.dataPermissionUserContextProvider = dataPermissionUserContextProvider;
    }

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        try {
            Method[] methodArr;
            Class<?> clazz = Class.forName(mappedStatementId.substring(0, mappedStatementId.lastIndexOf(".")));
            String methodName = mappedStatementId.substring(mappedStatementId.lastIndexOf(".") + 1);
            for (Method method : methodArr = clazz.getMethods()) {
                DataPermission dataPermission = method.getAnnotation(DataPermission.class);
                String name = method.getName();
                if (null == dataPermission || !CharSequenceUtil.equalsAny((CharSequence)methodName, (CharSequence[])new CharSequence[]{name, name + "_COUNT"}) || !this.dataPermissionUserContextProvider.isFilter()) continue;
                return this.buildDataScopeFilter(dataPermission, where);
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Data permission handler build data scope filter occurred an error: {}.", (Object)e.getMessage(), (Object)e);
        }
        return where;
    }

    private Expression buildDataScopeFilter(DataPermission dataPermission, Expression where) {
        AndExpression expression = null;
        UserContext userContext = this.dataPermissionUserContextProvider.getUserContext();
        Set roles = userContext.getRoles();
        block6: for (RoleContext roleContext : roles) {
            DataScope dataScope = roleContext.getDataScope();
            if (DataScope.ALL.equals((Object)dataScope)) {
                return where;
            }
            switch (dataScope) {
                case DEPT_AND_CHILD: {
                    expression = this.buildDeptAndChildExpression(dataPermission, userContext, (Expression)expression);
                    continue block6;
                }
                case DEPT: {
                    expression = this.buildDeptExpression(dataPermission, userContext, (Expression)expression);
                    continue block6;
                }
                case SELF: {
                    expression = this.buildSelfExpression(dataPermission, userContext, (Expression)expression);
                    continue block6;
                }
                case CUSTOM: {
                    expression = this.buildCustomExpression(dataPermission, roleContext, (Expression)expression);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301 [%s] \u6570\u636e\u6743\u9650".formatted(dataScope));
        }
        return where != null ? new AndExpression(where, (Expression)new ParenthesedExpressionList(new Expression[]{expression})) : expression;
    }

    private Expression buildDeptAndChildExpression(DataPermission dataPermission, UserContext userContext, Expression expression) {
        Function inSetExpression;
        ParenthesedSelect subSelect = new ParenthesedSelect();
        PlainSelect select = new PlainSelect();
        select.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column(dataPermission.id()))));
        select.setFromItem((FromItem)new Table(dataPermission.deptTableAlias()));
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(dataPermission.id()));
        equalsTo.setRightExpression((Expression)new LongValue(userContext.getDeptId()));
        DatabaseType databaseType = MetaUtils.getDatabaseType((DataSource)dataSource);
        if (DatabaseType.MYSQL.getDatabase().equalsIgnoreCase(databaseType.getDatabase())) {
            Function findInSetFunction = new Function();
            findInSetFunction.setName("find_in_set");
            findInSetFunction.setParameters(new ExpressionList((Expression[])new ASTNodeAccessImpl[]{new LongValue(userContext.getDeptId()), new StringValue(new Column("ancestors") + ",")}));
            inSetExpression = findInSetFunction;
        } else if (DatabaseType.POSTGRE_SQL.getDatabase().equalsIgnoreCase(databaseType.getDatabase())) {
            Function concatFunction = new Function("concat", new Expression[0]);
            concatFunction.setParameters(new ExpressionList((Expression[])new ASTNodeAccessImpl[]{new Column("ancestors"), new StringValue(",")}));
            LikeExpression likeExpression = new LikeExpression();
            likeExpression.setLeftExpression((Expression)concatFunction);
            likeExpression.setRightExpression((Expression)new StringValue("%," + userContext.getDeptId() + ",%"));
            inSetExpression = likeExpression;
        } else {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301 [%s] \u6570\u636e\u6743\u9650".formatted(""));
        }
        select.setWhere((Expression)new OrExpression((Expression)equalsTo, (Expression)inSetExpression));
        subSelect.setSelect((Select)select);
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        inExpression.setRightExpression((Expression)subSelect);
        return expression != null ? new OrExpression(expression, (Expression)inExpression) : inExpression;
    }

    private Expression buildDeptExpression(DataPermission dataPermission, UserContext userContext, Expression expression) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        equalsTo.setRightExpression((Expression)new LongValue(userContext.getDeptId()));
        return expression != null ? new OrExpression(expression, (Expression)equalsTo) : equalsTo;
    }

    private Expression buildSelfExpression(DataPermission dataPermission, UserContext userContext, Expression expression) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.userId()));
        equalsTo.setRightExpression((Expression)new LongValue(userContext.getUserId()));
        return expression != null ? new OrExpression(expression, (Expression)equalsTo) : equalsTo;
    }

    private Expression buildCustomExpression(DataPermission dataPermission, RoleContext roleContext, Expression expression) {
        ParenthesedSelect subSelect = new ParenthesedSelect();
        PlainSelect select = new PlainSelect();
        select.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column(dataPermission.deptId()))));
        select.setFromItem((FromItem)new Table(dataPermission.roleDeptTableAlias()));
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(dataPermission.roleId()));
        equalsTo.setRightExpression((Expression)new LongValue(roleContext.getRoleId()));
        select.setWhere((Expression)equalsTo);
        subSelect.setSelect((Select)select);
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)this.buildColumn(dataPermission.tableAlias(), dataPermission.deptId()));
        inExpression.setRightExpression((Expression)subSelect);
        return expression != null ? new OrExpression(expression, (Expression)inExpression) : inExpression;
    }

    private Column buildColumn(String tableAlias, String columnName) {
        if (StringUtils.isNotEmpty((CharSequence)tableAlias)) {
            return new Column("%s.%s".formatted(tableAlias, columnName));
        }
        return new Column(columnName);
    }
}

