/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.file.excel.converter;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class ExcelBigNumberConverter
implements Converter<Long> {
    private static final int MAX_LENGTH = 15;

    public Class<Long> supportJavaTypeKey() {
        return Long.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Long convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return Convert.toLong((Object)cellData.getData());
    }

    public WriteCellData<Object> convertToExcelData(Long value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String str;
        if (value != null && (str = Long.toString(value)).length() > 15) {
            return new WriteCellData(str);
        }
        WriteCellData writeCellData = new WriteCellData(NumberUtil.toBigDecimal((Number)value));
        writeCellData.setType(CellDataTypeEnum.NUMBER);
        return writeCellData;
    }
}

