/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.file.excel.converter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ExcelListConverter
implements Converter<List> {
    public Class supportJavaTypeKey() {
        return List.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public List convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String stringValue = cellData.getStringValue();
        return CharSequenceUtil.split((CharSequence)stringValue, (CharSequence)",");
    }

    public WriteCellData<Object> convertToExcelData(List value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        WriteCellData writeCellData = new WriteCellData(CollUtil.join((Iterable)value, (CharSequence)","));
        writeCellData.setType(CellDataTypeEnum.STRING);
        return writeCellData;
    }
}

